/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.unconstrained.annealing.annealingfunction;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.annealing.annealingfunction.AnnealingFunction;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.annealing.annealingfunction.GSAAnnealingFunction;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.Zignor2005;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BoxGSAAnnealingFunction
implements AnnealingFunction {
    private final Vector case;
    private final Vector false;
    private final GSAAnnealingFunction enum;

    public BoxGSAAnnealingFunction(Vector lower, Vector upper, double qv, RandomLongGenerator uniform) {
        this.case = lower;
        this.false = upper.minus(lower);
        this.enum = new GSAAnnealingFunction(qv, uniform, new Zignor2005(uniform));
    }

    @Override
    public Vector nextProposal(Vector currentState, double temperature) {
        Vector a2 = this.enum.nextProposal(currentState, temperature);
        for (int a3 = 1; a3 <= a2.size(); ++a3) {
            double a4 = a2.get(a3) - this.case.get(a3);
            double a5 = DoubleUtils.doubleMod(a4, this.false.get(a3)) + this.false.get(a3);
            double a6 = DoubleUtils.doubleMod(a5, this.false.get(a3)) + this.case.get(a3);
            a2.set(a3, a6);
            if (!(Math.abs(a2.get(a3) - this.case.get(a3)) < Constants.EPSILON)) continue;
            a2.set(a3, a2.get(a3) + Constants.EPSILON);
        }
        return a2;
    }
}

