/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.unconstrained.quasinewton;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.quasinewton.DFPMinimizer;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.quasinewton.QuasiNewtonMinimizer;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblem;
import com.numericalmethod.suanshu.optimization.problem.IterativeMinimizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFGSMinimizer
extends QuasiNewtonMinimizer {
    private final boolean enum;

    public static Matrix dampedBFGSHessianUpdate(Matrix H, Vector gamma, Vector delta) {
        double a2 = delta.innerProduct(gamma);
        double a3 = delta.innerProduct(H.multiply(delta));
        double a4 = 1.0;
        if (a2 < 0.2 * a3) {
            a4 = 0.8 * a3;
            a4 /= a3 - a2;
        }
        Vector a5 = gamma.scaled(a4);
        Vector a6 = H.multiply(delta).scaled(1.0 - a4);
        Vector a7 = a5.add(a6);
        Matrix a8 = DFPMinimizer.updateHessianInverse(H, new DenseMatrix(delta), new DenseMatrix(a7));
        return a8;
    }

    public static Matrix updateHessianInverse2(Matrix S, Matrix gamma, Matrix delta) {
        Inverse a2 = new Inverse(S, 0.0);
        Matrix a3 = DFPMinimizer.updateHessianInverse(a2, delta, gamma);
        Inverse a4 = new Inverse(a3, 0.0);
        return a4;
    }

    public BFGSMinimizer(boolean isFletcherSwitch, double epsilon, int maxIterations) {
        super(epsilon, maxIterations);
        this.enum = isFletcherSwitch;
    }

    @Override
    public IterativeMinimizer<Vector> solve(C2OptimProblem problem) throws Exception {
        return new BFGSImpl(problem);
    }

    public static Matrix updateHessianInverse1(Matrix S, Matrix gamma, Matrix delta) {
        Matrix a2 = gamma.t().multiply(S);
        Matrix a3 = gamma.t().multiply(delta);
        double a4 = a3.get(1, 1);
        double a5 = (1.0 + a2.multiply(gamma).get(1, 1) / a4) / a4;
        Matrix a6 = delta.multiply(delta.t());
        Matrix a7 = a6.scaled(a5);
        Matrix a8 = delta.multiply(a2);
        Matrix a9 = S.multiply(gamma).multiply(delta.t());
        Matrix a10 = a8.add(a9).scaled(-1.0 / a4);
        Matrix a11 = S.add(a7).add(a10);
        return a11;
    }

    protected class BFGSImpl
    extends QuasiNewtonMinimizer.QuasiNewtonImpl {
        @Override
        void updateSk(Vector a2) {
            CongruentMatrix a3;
            double a4;
            BFGSImpl a5;
            DenseMatrix a6 = new DenseMatrix(a2);
            DenseMatrix a7 = new DenseMatrix(a5.dk.scaled(a5.ak));
            Matrix a8 = a6.t().multiply(a7);
            double a9 = a8.get(1, 1);
            Matrix a10 = BFGSMinimizer.updateHessianInverse1(a5.Sk, a6, a7);
            if (a5.BFGSMinimizer.this.enum && a9 - (a4 = (a3 = new CongruentMatrix((Matrix)a6, a10)).get(1, 1)) > 0.0) {
                a10 = DFPMinimizer.updateHessianInverse(a5.Sk, a6, a7);
            }
            a5.Sk = a10;
        }

        public BFGSImpl(C2OptimProblem problem) throws Exception {
            super(problem);
        }
    }
}

