/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.unconstrained.steepestdescent;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.positivedefinite.GoldfeldQuandtTrotter;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.steepestdescent.SteepestDescentMinimizer;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblem;
import com.numericalmethod.suanshu.optimization.problem.IterativeMinimizer;

public class NewtonRaphsonMinimizer
extends SteepestDescentMinimizer {
    @Override
    public IterativeMinimizer<Vector> solve(C2OptimProblem problem) throws Exception {
        return new NewtonRaphsonImpl(problem);
    }

    public NewtonRaphsonMinimizer(double epsilon, int maxIterations) {
        super(epsilon, maxIterations);
    }

    protected class NewtonRaphsonImpl
    extends SteepestDescentMinimizer.SteepestDescentImpl {
        protected NewtonRaphsonImpl(C2OptimProblem problem) throws Exception {
            super(problem);
        }

        @Override
        public Vector getDirection(Vector xk) {
            Matrix a2;
            Vector a3 = (Vector)this.problem.g().evaluate(xk);
            Matrix a4 = (Matrix)this.problem.H().evaluate(xk);
            try {
                a2 = new Inverse(a4);
            }
            catch (Exception a5) {
                try {
                    GoldfeldQuandtTrotter a6 = new GoldfeldQuandtTrotter(a4, Double.POSITIVE_INFINITY);
                    a2 = new Inverse((Matrix)a6);
                }
                catch (Exception a7) {
                    a2 = a4.ONE();
                }
            }
            Vector a8 = a2.multiply(a3);
            a8 = a8.scaled(-1.0);
            return a8;
        }
    }
}

