/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.problem;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.GradientFunction;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.HessianFunction;
import com.numericalmethod.suanshu.analysis.function.matrix.RntoMatrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class C2OptimProblemImpl
implements C2OptimProblem {
    private final RealVectorFunction case;
    private final RntoMatrix false;
    private final RealScalarFunction enum;

    public C2OptimProblemImpl(RealScalarFunction f, RealVectorFunction g2, RntoMatrix H) {
        ArgumentAssertion.assertTrue(f.dimensionOfDomain() == g2.dimensionOfDomain(), "objective function and gradient must have the same domain dimension", new Object[0]);
        ArgumentAssertion.assertTrue(f.dimensionOfDomain() == H.dimensionOfDomain(), "objective function and Hessian must have the same domain dimension", new Object[0]);
        this.enum = f;
        this.case = g2;
        this.false = H;
    }

    public C2OptimProblemImpl(C2OptimProblemImpl that) {
        this(that.enum);
    }

    public C2OptimProblemImpl(RealScalarFunction f) {
        this(f, new GradientFunction(f));
    }

    @Override
    public int dimension() {
        return this.enum.dimensionOfDomain();
    }

    @Override
    public RealScalarFunction f() {
        return this.enum;
    }

    @Override
    public RntoMatrix H() {
        return this.false;
    }

    @Override
    public RealVectorFunction g() {
        return this.case;
    }

    public C2OptimProblemImpl(RealScalarFunction f, RealVectorFunction g2) {
        this(f, g2, new HessianFunction(f));
    }
}

