/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate.bracketsearch;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblemImpl;
import com.numericalmethod.suanshu.optimization.univariate.UnivariateMinimizer;

public abstract class BracketSearchMinimizer
implements UnivariateMinimizer {
    protected final double epsilon;
    protected final int maxIterations;

    protected BracketSearchMinimizer(double epsilon, int maxIterations) {
        double a2 = Math.sqrt(Constants.EPSILON);
        this.epsilon = epsilon < a2 ? a2 : epsilon;
        this.maxIterations = maxIterations;
    }

    @Override
    public UnivariateMinimizer.Solution solve(UnivariateRealFunction f) throws Exception {
        return (UnivariateMinimizer.Solution)this.solve(new C2OptimProblemImpl(f));
    }

    protected abstract class Solution
    implements UnivariateMinimizer.Solution {
        protected double xnext;
        protected double xmin;
        protected int iter;
        protected UnivariateRealFunction f;
        protected double fmin;
        protected double xu;
        protected double xl;
        protected double fnext;

        @Override
        public Double minimizer() {
            return this.xmin;
        }

        protected abstract boolean isMinFound();

        protected abstract double xnext();

        @Override
        public double search(double lower, double initial, double upper) {
            ArgumentAssertion.assertTrue(lower < initial && initial < upper, "invalid bracket interval", new Object[0]);
            ArgumentAssertion.assertTrue(this.isBracketing(lower, initial, upper), "the interval specified may not bracket a minimum", new Object[0]);
            this.xl = lower;
            this.xu = upper;
            this.xmin = initial;
            this.fmin = this.f.evaluate(this.xmin);
            this.iter = 1;
            while (this.iter <= BracketSearchMinimizer.this.maxIterations && !this.isMinFound()) {
                this.xnext = this.xnext();
                if (this.xnext <= this.xl || this.xu <= this.xnext) break;
                this.fnext = this.f.evaluate(this.xnext);
                this.updateStates();
                ++this.iter;
            }
            double a2 = 0.5 * this.xl + 0.5 * this.xu;
            return a2;
        }

        protected void updateStates() {
            if (this.fnext < this.fmin) {
                if (this.xnext < this.xmin) {
                    this.xu = this.xmin;
                } else {
                    this.xl = this.xmin;
                }
                this.xmin = this.xnext;
                this.fmin = this.fnext;
            } else if (this.xnext < this.xmin) {
                this.xl = this.xnext;
            } else {
                this.xu = this.xnext;
            }
        }

        protected Solution(UnivariateRealFunction f) {
            this.f = f;
        }

        @Override
        public double minimum() {
            return this.fmin;
        }

        protected boolean isBracketing(double xl, double x, double xu) {
            double a2 = this.f.evaluate(xl);
            double a3 = this.f.evaluate(x);
            double a4 = this.f.evaluate(xu);
            boolean a5 = false;
            if (a3 < a2 && a3 < a4) {
                a5 = true;
            }
            return a5;
        }
    }
}

