/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate.bracketsearch;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblem;
import com.numericalmethod.suanshu.optimization.univariate.bracketsearch.BracketSearchMinimizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BrentMinimizer
extends BracketSearchMinimizer {
    private final double enum = 1.0 - 1.0 / Constants.GOLDEN_RATIO;

    @Override
    public Solution solve(C2OptimProblem problem) {
        return new Solution((UnivariateRealFunction)problem.f());
    }

    public BrentMinimizer(double epsilon, int maxIterations) {
        super(epsilon, maxIterations);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Solution
    extends BracketSearchMinimizer.Solution {
        private double new;
        private double const;
        private double case;
        private double false;
        private double enum;

        @Override
        public double search(double lower, double initial, double upper) {
            this.new = this.false = initial;
            this.enum = this.case = this.f.evaluate(initial);
            super.search(lower, initial, upper);
            return this.xmin;
        }

        @Override
        protected boolean isMinFound() {
            boolean a2 = false;
            double a3 = 0.5 * (this.xu - this.xl);
            double a4 = BrentMinimizer.this.epsilon * Math.abs(this.xmin) + Constants.EPSILON;
            double a5 = 2.0 * a4;
            if (0.5 * (this.xu - this.xl) + Math.abs(this.xmin - a3) <= a5) {
                a2 = true;
            }
            return a2;
        }

        @Override
        protected void updateStates() {
            if (this.fnext < this.fmin) {
                this.false = this.new;
                this.case = this.enum;
                this.new = this.xmin;
                this.enum = this.fmin;
            } else if (this.fnext <= this.enum || this.new == this.xmin) {
                this.false = this.new;
                this.case = this.enum;
                this.new = this.xnext;
                this.enum = this.fnext;
            } else if (this.fnext <= this.case || this.false == this.xmin || this.false == this.new) {
                this.false = this.xnext;
                this.case = this.fnext;
            }
            super.updateStates();
        }

        @Override
        protected double xnext() {
            double a2 = 0.0;
            double a3 = BrentMinimizer.this.epsilon * Math.abs(this.xmin) + Constants.EPSILON;
            double a4 = 0.5 * this.xl + 0.5 * this.xu;
            a2 = BrentMinimizer.this.enum * ((this.xmin < a4 ? this.xu : this.xl) - this.xmin);
            if (Math.abs(this.const) > a3) {
                double a5;
                double a6;
                double a7 = this.xmin;
                double a8 = this.fmin;
                double a9 = (a7 - this.new) * (a8 - this.case);
                double a10 = (a7 - this.false) * (a8 - this.enum);
                double a11 = (a7 - this.false) * a10 - (a7 - this.new) * a9;
                if ((a10 = 2.0 * (a10 - a9)) > 0.0) {
                    a11 = -a11;
                } else {
                    a10 = -a10;
                }
                if (Math.abs(a11) < Math.abs(0.5 * a10 * this.const) && a11 > a10 * (this.xl - a7) && a11 < a10 * (this.xu - a7) && ((a6 = this.xmin + (a2 = a11 / a10)) - this.xl < (a5 = 2.0 * a3) || this.xu - a6 < a5)) {
                    a2 = a7 < a4 ? a3 : -a3;
                }
            }
            this.const = a2;
            return this.xmin + a2;
        }

        @Override
        public double search(double lower, double upper) {
            double a2 = lower + BrentMinimizer.this.enum * (upper - lower);
            this.search(lower, a2, upper);
            return this.xmin;
        }

        private Solution(UnivariateRealFunction a2) {
            Solution a3;
            super(a3.BrentMinimizer.this, a2);
            a3.const = 0.0;
        }
    }
}

