/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate.bracketsearch;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblem;
import com.numericalmethod.suanshu.optimization.univariate.bracketsearch.BracketSearchMinimizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GoldenMinimizer
extends BracketSearchMinimizer {
    private final double enum = 1.0 - 1.0 / Constants.GOLDEN_RATIO;

    public GoldenMinimizer(double epsilon, int maxIterations) {
        super(epsilon, maxIterations);
    }

    @Override
    public Solution solve(C2OptimProblem problem) {
        return new Solution((UnivariateRealFunction)problem.f());
    }

    public class Solution
    extends BracketSearchMinimizer.Solution {
        @Override
        public double search(double lower, double upper) {
            double a2 = lower + GoldenMinimizer.this.enum * (upper - lower);
            return super.search(lower, a2, upper);
        }

        @Override
        protected boolean isMinFound() {
            return this.xu - this.xl < GoldenMinimizer.this.epsilon;
        }

        @Override
        protected double xnext() {
            double a2 = this.xu - this.xmin;
            double a3 = this.xmin - this.xl;
            double a4 = this.xmin;
            return a4 += GoldenMinimizer.this.enum * (a2 > a3 ? a2 : -a3);
        }

        private Solution(UnivariateRealFunction a2) {
            Solution a3;
            super(a3.GoldenMinimizer.this, a2);
        }
    }
}

