/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.correlation;

import com.numericalmethod.suanshu.analysis.function.tuple.Pair;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import com.numericalmethod.suanshu.stats.descriptive.covariance.Covariance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SpearmanRankCorrelation
implements Statistic {
    private final List<Pair> case = new ArrayList<Pair>();
    private static final Comparator<Pair> false = new Comparator<Pair>(){

        @Override
        public int compare(Pair o1, Pair o2) {
            return Double.compare(o1.x(), o2.x());
        }
        {
            1 a2;
        }
    };
    private static final Comparator<Pair> enum = new Comparator<Pair>(){

        @Override
        public int compare(Pair o1, Pair o2) {
            return Double.compare(o1.y(), o2.y());
        }
        {
            2 a2;
        }
    };

    private Map<Pair, Double> do(Comparator<Pair> a2) {
        SpearmanRankCorrelation a3;
        HashMap<Pair, Double> a4 = new HashMap<Pair, Double>();
        Collections.sort(a3.case, a2);
        int a5 = a3.case.size();
        ArrayList<Pair> a6 = new ArrayList<Pair>(a5);
        int a7 = 0;
        int a8 = 0;
        int a9 = 1;
        while (a8 < a5) {
            Pair a10 = a3.case.get(a8);
            a6.add(a10);
            a7 += a9;
            boolean a11 = a3.do(a8, a2);
            if (!a11) {
                double a12 = (double)a7 / (double)a6.size();
                for (Pair a13 : a6) {
                    a4.put(a13, a12);
                }
                a6.clear();
                a7 = 0;
            }
            ++a8;
            ++a9;
        }
        return a4;
    }

    private boolean do(int a2, Comparator<Pair> a3) {
        Pair a4;
        SpearmanRankCorrelation a5;
        boolean a6;
        boolean bl = a6 = a2 == a5.case.size() - 1;
        if (a6) {
            return false;
        }
        Pair a7 = a5.case.get(a2);
        return a3.compare(a7, a4 = a5.case.get(a2 + 1)) == 0;
    }

    @Override
    public long N() {
        return this.case.size();
    }

    @Override
    public void addData(double ... data) {
        ArgumentAssertion.assertTrue(data.length % 2 == 0, "there must be an even number of data points", new Object[0]);
        int a2 = data.length / 2;
        double[] a3 = Arrays.copyOfRange(data, 0, a2);
        double[] a4 = Arrays.copyOfRange(data, a2, data.length);
        this.addData(a3, a4);
    }

    public SpearmanRankCorrelation(double[] data1, double[] data2) {
        this.addData(data1, data2);
    }

    @Override
    public double value() {
        Map<Pair, Double> a2 = this.do(false);
        Map<Pair, Double> a3 = this.do(enum);
        int a4 = this.case.size();
        double[] a5 = new double[a4];
        double[] a6 = new double[a4];
        for (int a7 = 0; a7 < a4; ++a7) {
            Pair a8 = this.case.get(a7);
            a5[a7] = a2.get(a8);
            a6[a7] = a3.get(a8);
        }
        return new Covariance(a5, a6).correlation();
    }

    public void addData(double[] data1, double[] data2) {
        ArgumentAssertion.assertEqual(data1.length, data2.length, "data1's length", "data2's length");
        for (int a2 = 0; a2 < data1.length; ++a2) {
            this.case.add(new Pair(data1[a2], data2[a2]));
        }
    }
}

