/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.covariance;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Covariance
implements Statistic {
    private Variance const;
    private Variance case = new Variance();
    private long false = 0L;
    private double enum = 0.0;

    public void addData(double[] data1, double[] data2) {
        this.do(data1, data2);
    }

    public double correlation() {
        return this.value() / this.case.standardDeviation() / this.const.standardDeviation();
    }

    public Covariance(Covariance that) {
        this.const = new Variance();
        this.false = that.false;
        this.case = that.case;
        this.const = that.const;
        this.enum = that.enum;
    }

    public Covariance() {
        this.const = new Variance();
    }

    private void do(double[] a2, double[] a3) {
        Covariance a4;
        ArgumentAssertion.assertEqual(a2.length, a3.length, "data1's length", "data2's length");
        if (a4.false == 0L) {
            a4.false = a2.length;
            a4.case.addData(a2);
            a4.const.addData(a3);
            double a5 = a4.case.mean();
            double a6 = a4.const.mean();
            a4.enum = 0.0;
            int a7 = 0;
            while ((long)a7 < a4.false) {
                a4.enum += (a2[a7] - a5) * (a3[a7] - a6);
                ++a7;
            }
            return;
        }
        Covariance a8 = new Covariance(a2, a3);
        long a9 = a4.false + a8.false;
        double a10 = a8.case.mean() - a4.case.mean();
        double a11 = a8.const.mean() - a4.const.mean();
        double a12 = (double)a4.false / (double)a9 * (double)a8.false;
        a4.enum += a8.enum + (a12 *= a10 * a11);
        a4.case.addData(a2);
        a4.const.addData(a3);
        a4.false = a9;
    }

    @Override
    public void addData(double ... data) {
        ArgumentAssertion.assertTrue(data.length % 2 == 0, "there must be an even number of data points", new Object[0]);
        int a2 = data.length / 2;
        double[] a3 = Arrays.copyOfRange(data, 0, a2);
        double[] a4 = Arrays.copyOfRange(data, a2, data.length);
        this.addData(a3, a4);
    }

    @Override
    public long N() {
        return this.false;
    }

    @Override
    public double value() {
        return this.false > 1L ? this.enum / (double)(this.false - 1L) : Double.NaN;
    }

    public Covariance(double[] data1, double[] data2) {
        this.const = new Variance();
        this.do(data1, data2);
    }

    static {
        Package.validate("BASIC");
    }

    public String toString() {
        return String.format("covariance: %f; correlation: %f, N: %d", this.value(), this.correlation(), this.false);
    }
}

