/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.multivariate;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.function.special.gamma.Gamma;
import com.numericalmethod.suanshu.analysis.function.special.gamma.GammaLanczosQuick;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.distribution.multivariate.MultivariateProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateTDistribution
implements MultivariateProbabilityDistribution {
    private final double char;
    private final Matrix new;
    private final ImmutableVector const;
    private final double case;
    private final ImmutableMatrix false;
    private final Gamma enum = new GammaLanczosQuick();

    public MultivariateTDistribution(int v, Vector mu, Matrix Sigma) {
        ArgumentAssertion.assertTrue(mu.size() == Sigma.nCols() && Sigma.nCols() == Sigma.nRows(), "the size of the mean vector must match the size of the covariance matrix", new Object[0]);
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(Sigma, 0.0), "the covariance matrix must be symmetric", new Object[0]);
        this.case = v;
        this.const = new ImmutableVector(mu);
        this.false = new ImmutableMatrix(Sigma);
        this.new = new Inverse(Sigma);
        this.char = this.do();
    }

    @Override
    public Vector mean() {
        if (this.case <= 1.0) {
            throw new RuntimeException("mean undefined when v <= 1");
        }
        return this.const;
    }

    @Override
    public Vector mode() {
        return this.const;
    }

    @Override
    public Matrix covariance() {
        if (this.case <= 2.0) {
            throw new RuntimeException("covariance undefined when v <= 2");
        }
        DenseMatrix a2 = new DenseMatrix(this.false);
        double a3 = this.case / (this.case - 2.0);
        a2.scaled(a3);
        return a2;
    }

    private double do() {
        MultivariateTDistribution a2;
        double a3 = a2.const.size();
        double a4 = MatrixMeasure.det(a2.false);
        double a5 = a2.enum.evaluate((a2.case + a3) / 2.0);
        double a6 = a2.enum.evaluate(a2.case / 2.0);
        double a7 = Math.pow(a2.case * Math.PI, a3 / 2.0);
        double a8 = Math.sqrt(a4);
        double a9 = a5 / a6 / a7 / a8;
        return a9;
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("not yet supported");
    }

    public MultivariateTDistribution(int dim, int v) {
        this(v, new DenseVector(dim), ((DenseMatrix)new DenseMatrix(dim, dim).ONE()).scaled((double)(v - 2) / (double)v));
    }

    @Override
    public double density(Vector x) {
        double a2 = this.const.size();
        Vector a3 = x.minus(this.const);
        double a4 = a3.innerProduct(this.new.multiply(a3));
        double a5 = Math.pow(a4 / this.case + 1.0, (this.case + a2) / 2.0);
        double a6 = this.char / a5;
        return a6;
    }

    @Override
    public double moment(Vector t) {
        throw new UnsupportedOperationException("not yet supported");
    }

    @Override
    public double cdf(Vector x) {
        throw new UnsupportedOperationException("not yet supported");
    }
}

