/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.beta.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.beta.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.beta.LogBeta;
import com.numericalmethod.suanshu.analysis.function.special.gamma.Digamma;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BetaDistribution
implements ProbabilityDistribution {
    private static final Digamma char;
    private final double new;
    private final BetaRegularizedInverse const;
    private static final LogBeta case;
    private final double false;
    private final BetaRegularized enum;

    @Override
    public double density(double x) {
        assert (x >= 0.0) : "x must be >= 0";
        assert (x <= 1.0) : "x must be <= 1";
        if (DoubleUtils.isZero(x, 0.0)) {
            if (this.new < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        double a2 = (this.new - 1.0) * Math.log(x) + (this.false - 1.0) * Math.log(1.0 - x) - case.evaluate(this.new, this.false);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be >= 0";
        assert (x <= 1.0) : "x must be <= 1";
        return this.enum.evaluate(x);
    }

    @Override
    public double quantile(double u) {
        double a2 = this.const.evaluate(u);
        return a2;
    }

    @Override
    public double kurtosis() {
        double a2 = 6.0;
        a2 *= this.new * this.new * this.new - this.new * this.new * (2.0 * this.false - 1.0) + this.false * this.false * (this.false + 1.0) - 2.0 * this.new * this.false * (this.false + 2.0);
        return a2 /= this.new * this.false * (this.new + this.false + 2.0) * (this.new + this.false + 3.0);
    }

    static {
        case = new LogBeta();
        char = new Digamma();
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BetaDistribution(double alpha, double beta) {
        ArgumentAssertion.assertPositive(alpha, "alpha");
        ArgumentAssertion.assertPositive(beta, "beta");
        this.new = alpha;
        this.false = beta;
        this.enum = new BetaRegularized(alpha, beta);
        this.const = new BetaRegularizedInverse(alpha, beta);
    }

    @Override
    public double skew() {
        double a2 = this.new + this.false;
        double a3 = 2.0 * (this.false - this.new) * Math.sqrt(a2 + 1.0);
        return a3 /= (a2 + 2.0) * Math.sqrt(this.new * this.false);
    }

    @Override
    public double mean() {
        return this.new / (this.new + this.false);
    }

    @Override
    public double variance() {
        double a2 = this.new + this.false;
        double a3 = this.new * this.false;
        return a3 /= a2 * a2 * (a2 + 1.0);
    }

    @Override
    public double entropy() {
        double a2 = case.evaluate(this.new, this.false);
        a2 -= (this.new - 1.0) * char.evaluate(this.new);
        a2 -= (this.false - 1.0) * char.evaluate(this.false);
        return a2 += (this.new + this.false - 2.0) * char.evaluate(this.new + this.false);
    }

    public double ccdf(double x) {
        return 1.0 - this.cdf(x);
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("no closed form.");
    }
}

