/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.beta.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.beta.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.beta.LogBeta;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.ExceptionUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FDistribution
implements ProbabilityDistribution {
    private final BetaRegularizedInverse new;
    private final double const;
    private final BetaRegularized case;
    private final double false;
    private static final LogBeta enum = new LogBeta();

    public FDistribution(double df1, double df2) {
        ArgumentAssertion.assertPositive(df1, "df1");
        ArgumentAssertion.assertPositive(df2, "df2");
        this.const = df1;
        this.false = df2;
        this.case = new BetaRegularized(df1 / 2.0, df2 / 2.0);
        this.new = new BetaRegularizedInverse(df1 / 2.0, df2 / 2.0);
    }

    @Override
    public double kurtosis() {
        ExceptionUtils.throwIfNotNull(this.false > 8.0 ? null : new UnsupportedOperationException("only supported for df2 > 8"));
        double a2 = 5.0 * this.false * this.false * this.const - 22.0 * this.const * this.const + 5.0 * this.false * this.const * this.const - 16.0;
        double a3 = 20.0 * this.false - 8.0 * this.false * this.false + this.false * this.false * this.false + 44.0 * this.const - 32.0 * this.const * this.false + a2;
        return (a3 /= this.const * (this.false - 6.0) * (this.false - 8.0) * (this.const + this.false - 2.0) / 12.0) - 3.0;
    }

    @Override
    @Deprecated
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mean() {
        ExceptionUtils.throwIfNotNull(this.false > 2.0 ? null : new UnsupportedOperationException("only supported for df2 > 2"));
        return this.false / (this.false - 2.0);
    }

    @Override
    public double density(double x) {
        ArgumentAssertion.assertNonNegative(x, "x");
        if (DoubleUtils.isZero(x, 0.0)) {
            if (this.const < 2.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.const == 2.0) {
                return 1.0;
            }
            return 0.0;
        }
        double a2 = this.const * Math.log(this.const * x);
        a2 += this.false * Math.log(this.false);
        a2 -= (this.const + this.false) * Math.log(this.const * x + this.false);
        a2 /= 2.0;
        a2 -= Math.log(x);
        a2 -= enum.evaluate(this.const / 2.0, this.false / 2.0);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double quantile(double u) {
        double a2 = this.new.evaluate(u);
        return this.false * a2 / (this.const - this.const * a2);
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("does not exist.");
    }

    @Override
    public double skew() {
        ExceptionUtils.throwIfNotNull(this.false > 6.0 ? null : new UnsupportedOperationException("only supported for df2 > 6"));
        double a2 = (2.0 * this.const + this.false - 2.0) * Math.sqrt(8.0 * (this.false - 4.0));
        return a2 /= (this.false - 6.0) * Math.sqrt(this.const * (this.const + this.false - 2.0));
    }

    @Override
    public double cdf(double x) {
        ArgumentAssertion.assertNonNegative(x, "x");
        return this.case.evaluate(this.const * x / (this.const * x + this.false));
    }

    @Override
    public double variance() {
        ExceptionUtils.throwIfNotNull(this.false > 4.0 ? null : new UnsupportedOperationException("only supported for df2 > 4"));
        double a2 = 2.0 * this.false * this.false * (this.const + this.false - 2.0);
        return a2 /= this.const * (this.false - 2.0) * (this.false - 2.0) * (this.false - 4.0);
    }
}

