/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.gaussian.Erf;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RayleighDistribution
implements ProbabilityDistribution {
    private final double enum;

    public RayleighDistribution(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma must be > 0");
        }
        this.enum = sigma;
    }

    @Override
    public double quantile(double u) {
        return this.enum * Math.sqrt(-2.0 * Math.log(1.0 - u));
    }

    static {
        Package.validate("BASIC");
    }

    @Override
    public double kurtosis() {
        return 0.2450893006876391;
    }

    @Override
    public double density(double x) {
        assert (x >= 0.0) : "x must be positive";
        return x / this.enum / this.enum * Math.exp(-x * x / 2.0 / this.enum / this.enum);
    }

    @Override
    public double entropy() {
        return 1.0 + Math.log(this.enum / Constants.ROOT_2) + 0.28860783245076643;
    }

    @Override
    public double moment(double t) {
        Erf a2 = new Erf();
        return 1.0 + this.enum * t * Math.exp(this.enum * this.enum * t * t / 2.0) * Math.sqrt(1.5707963267948966) * (a2.evaluate(this.enum * t / Constants.ROOT_2) + 1.0);
    }

    @Override
    public double skew() {
        return 2.0 * Constants.ROOT_PI * 0.14159265358979312 / Math.pow(0.8584073464102069, 1.5);
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return 1.0 - Math.exp(-x * x / 2.0 / this.enum / this.enum);
    }

    @Override
    public double median() {
        return this.enum * Math.sqrt(Math.log(4.0));
    }

    @Override
    public double variance() {
        return this.enum * this.enum * 0.8584073464102069 / 2.0;
    }

    @Override
    public double mean() {
        return this.enum * Math.sqrt(1.5707963267948966);
    }
}

