/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.univariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.random.rng.RNGUtils;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.RandomStandardNormalGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObservationEquation {
    private final UnivariateRealFunction case;
    private final UnivariateRealFunction false;
    private final RandomStandardNormalGenerator enum;

    public double yt_var(int t, double var_t_tlag) {
        double a2 = this.F(t);
        double a3 = this.V(t);
        double a4 = a2 * var_t_tlag * a2 + a3;
        return a4;
    }

    public double yt(int t, double xt) {
        double a2 = this.yt_mean(t, xt);
        double a3 = this.enum.nextDouble() * Math.sqrt(this.false.evaluate(t));
        return a2 += a3;
    }

    public ObservationEquation(UnivariateRealFunction F2, UnivariateRealFunction V) {
        this(F2, V, RNGUtils.RNORM);
    }

    public int dimension() {
        return 1;
    }

    public ObservationEquation(UnivariateRealFunction F2, UnivariateRealFunction V, RandomStandardNormalGenerator rnorm) {
        ArgumentAssertion.assertTrue(F2.dimensionOfDomain() == V.dimensionOfDomain(), "the domain dimensions of F and V must match", new Object[0]);
        this.case = F2;
        this.false = V;
        this.enum = rnorm;
    }

    public ObservationEquation(ObservationEquation that) {
        this(that.case, that.false);
    }

    public ObservationEquation(double F2, double V) {
        this(F2, V, RNGUtils.RNORM);
    }

    public ObservationEquation(final double F2, final double V, RandomStandardNormalGenerator rnorm) {
        this(new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return F2;
            }
            {
                1 a2;
            }
        }, new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return V;
            }
            {
                2 a2;
            }
        }, rnorm);
    }

    public double V(int t) {
        return this.false.evaluate(t);
    }

    public double F(int t) {
        return this.case.evaluate(t);
    }

    public double yt_mean(int t, double xt) {
        double a2 = this.case.evaluate(t) * xt;
        return a2;
    }
}

