/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.univariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.random.rng.RNGUtils;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.RandomStandardNormalGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StateEquation {
    private final RandomStandardNormalGenerator const;
    private final UnivariateRealFunction case;
    private final UnivariateRealFunction false;
    private final UnivariateRealFunction enum;

    public double xt_mean(int t, double xt_1, double ut) {
        double a2 = this.false.evaluate(t) * xt_1;
        if (this.enum != null) {
            double a3 = this.enum.evaluate(t) * ut;
            a2 += a3;
        }
        return a2;
    }

    public StateEquation(double G2, double W) {
        this(G2, 0.0, W, RNGUtils.RNORM);
    }

    public double xt(int t, double xt_1) {
        return this.xt(t, xt_1, 0.0);
    }

    public StateEquation(final double G2, final double H, final double W, RandomStandardNormalGenerator rnorm) {
        this(new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return G2;
            }
            {
                2 a2;
            }
        }, new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return H;
            }
            {
                3 a2;
            }
        }, new AbstractUnivariateRealFunction(){
            {
                4 a2;
            }

            @Override
            public double evaluate(double x) {
                return W;
            }
        }, rnorm);
    }

    public StateEquation(UnivariateRealFunction G2, UnivariateRealFunction W) {
        this(G2, new AbstractUnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return 0.0;
            }
        }, W);
    }

    public StateEquation(StateEquation that) {
        this(that.false, that.enum, that.case);
    }

    public StateEquation(UnivariateRealFunction G2, UnivariateRealFunction H, UnivariateRealFunction W) {
        this(G2, H, W, RNGUtils.RNORM);
    }

    public int dimension() {
        return 1;
    }

    public double xt(int t, double xt_1, double ut) {
        double a2 = this.xt_mean(t, xt_1, ut);
        double a3 = this.const.nextDouble() * Math.sqrt(this.case.evaluate(t));
        return a2 += a3;
    }

    public double W(int t) {
        return this.case.evaluate(t);
    }

    public double H(int t) {
        return this.enum.evaluate(t);
    }

    public StateEquation(UnivariateRealFunction G2, UnivariateRealFunction H, UnivariateRealFunction W, RandomStandardNormalGenerator rnorm) {
        ArgumentAssertion.assertTrue(G2.dimensionOfDomain() == H.dimensionOfDomain() && H.dimensionOfDomain() == W.dimensionOfDomain(), "the domain dimensions of F and V and W must match", new Object[0]);
        this.false = G2;
        this.enum = H;
        this.case = W;
        this.const = rnorm;
    }

    public double G(int t) {
        return this.false.evaluate(t);
    }

    public double xt_var(int t, double var_tlag_tlag) {
        double a2 = this.G(t);
        double a3 = this.W(t);
        double a4 = a2 * var_tlag_tlag * a2 + a3;
        return a4;
    }

    public double xt_mean(int t, double xt_1) {
        return this.xt_mean(t, xt_1, 0.0);
    }
}

