/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.bivariate;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.distribution.univariate.ExponentialDistribution;
import com.numericalmethod.suanshu.stats.evt.evd.bivariate.BivariateEVD;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.GeneralizedEVD;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDLogistic
implements BivariateEVD {
    private final GeneralizedEVD new;
    private static final ExponentialDistribution const;
    private final UniformRNG case = new UniformRNG();
    private final GeneralizedEVD false;
    private final double enum;

    public GeneralizedEVD getMarginal2() {
        return this.false;
    }

    private double do() {
        BivariateEVDLogistic a2;
        double a3 = a2.case.nextDouble();
        return const.quantile(a3);
    }

    public BivariateEVDLogistic(double dependence, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertRangeLeftOpen(dependence, 0.0, 1.0, "dependence");
        this.enum = dependence;
        this.new = marginal1;
        this.false = marginal2;
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        double a2 = -Math.log(x1);
        double a3 = -Math.log(x2);
        double a4 = 1.0 / this.enum;
        double a5 = Math.pow(a2, a4) + Math.pow(a3, a4);
        double a6 = Math.pow(a5, this.enum);
        double a7 = Math.exp(-a6) * (1.0 / x2) * Math.pow(a3, a4 - 1.0) * Math.pow(a5, this.enum - 1.0);
        return a7;
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = 1.0 / this.enum;
        return (a2 - 1.0) * Math.pow(x * (1.0 - x), -1.0 - a2) * Math.pow(Math.pow(x, -a2) + Math.pow(1.0 - x, -a2), this.enum - 2.0);
    }

    @Override
    public double[] nextVector() {
        double[] a2 = new double[2];
        double a3 = this.case.nextDouble() < this.enum ? this.do() + this.do() : this.do();
        double a4 = this.case.nextDouble();
        a2[0] = 1.0 / (a3 * Math.pow(a4, this.enum));
        a2[1] = 1.0 / (a3 * Math.pow(1.0 - a4, this.enum));
        double a5 = this.new.marginalInverseTransform(1.0 / a2[0]);
        double a6 = this.false.marginalInverseTransform(1.0 / a2[1]);
        return new double[]{a5, a6};
    }

    public GeneralizedEVD getMarginal1() {
        return this.new;
    }

    @Override
    public void seed(long ... seeds) {
        this.case.seed(seeds);
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.new.marginalTransform(x1);
        double a3 = this.false.marginalTransform(x2);
        double a4 = Math.pow(Math.pow(a2, 1.0 / this.enum) + Math.pow(a3, 1.0 / this.enum), this.enum);
        return Math.exp(-a4);
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = 1.0 / this.enum;
        return Math.pow(Math.pow(x, a2) + Math.pow(1.0 - x, a2), this.enum);
    }

    static {
        Package.validate("EVT");
        const = new ExponentialDistribution();
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.new.marginalTransform(x1);
        double a4 = this.false.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            double a5 = 1.0 / this.enum;
            double a6 = Math.pow(Math.pow(a3, a5) + Math.pow(a4, a5), this.enum);
            double a7 = Math.log(a3);
            double a8 = Math.log(a4);
            a2 = (a5 + this.new.getShape()) * a7 + (a5 + this.false.getShape()) * a8 - Math.log(this.new.getScale() * this.false.getScale()) + (1.0 - 2.0 * a5) * Math.log(a6) + Math.log(a5 - 1.0 + a6) - a6;
        }
        return Math.exp(a2);
    }

    public BivariateEVDLogistic(double dependence) {
        this(dependence, new GeneralizedEVD());
    }

    public BivariateEVDLogistic(double dependence, GeneralizedEVD marginal) {
        this(dependence, marginal, marginal);
    }
}

