/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractRealScalarFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.number.doublearray.SimpleDoubleArrayOperation;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.general.GeneralGreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.general.sqp.activeset.SQPActiveSetOnlyInequalityConstraintMinimizer;
import com.numericalmethod.suanshu.optimization.problem.IterativeMinimizer;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.ACERFunction;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.ACERLogFunction;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.LinearFit;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.EmpiricalACER;
import com.numericalmethod.suanshu.stats.regression.WeightedRSS;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NonlinearFit {
    private static final LinearFit enum;

    public static double[] computeWeights(double[] epsilon, double[] confint) {
        SimpleDoubleArrayOperation a2 = new SimpleDoubleArrayOperation();
        double[] a3 = a2.add(epsilon, confint);
        double[] a4 = a2.minus(epsilon, confint);
        double[] a5 = DoubleArrayMath.pow(a2.minus(DoubleArrayMath.log(a3), DoubleArrayMath.log(a4)), -2.0);
        double a6 = DoubleArrayMath.sum(a5);
        a5 = DoubleArrayMath.scale(a5, 1.0 / a6);
        return a5;
    }

    private int[] do(double[] a2, double[] a3, double[] a4, double a5) {
        int a6 = a2.length;
        int[] a7 = new int[a6];
        int a8 = 0;
        for (int a9 = 0; a9 < a6; ++a9) {
            if (!(a2[a9] > 0.0) || !(a4[a9] > a5) || !(a3[a9] < a2[a9])) continue;
            a7[a8++] = a9;
        }
        return Arrays.copyOf(a7, a8);
    }

    public Result fit(double[] eta, double[] epsilon, double[] confWidth, double peakMean, double tailMarker) {
        int[] a2 = this.do(epsilon, confWidth, eta, tailMarker);
        ArgumentAssertion.assertTrue(a2.length != 0, "failed to fit parameter: too bad estimates", Arrays.toString(epsilon));
        double[] a3 = DoubleUtils.subarray(eta, a2);
        double[] a4 = DoubleUtils.subarray(epsilon, a2);
        double[] a5 = DoubleUtils.subarray(confWidth, a2);
        return this.fitWithWeights(a3, a4, NonlinearFit.computeWeights(a4, a5), peakMean, DoubleArrayMath.min(eta), tailMarker);
    }

    public Result fit(EmpiricalACER estimates, double tailMarker) {
        return this.fit(estimates.getBarrierLevels(), estimates.getMeans(), estimates.getConfidenceWidths(), estimates.getPeakMean(), tailMarker);
    }

    public Result fitWithWeightsAndInitial(final double[] eta, final double[] epsilon, final double[] weights, ACERFunction.ACERParameter initial, final double minLevel, double tailMarker) {
        ACERFunction.ACERParameter a2;
        final double a3 = DoubleArrayMath.max(tailMarker, minLevel);
        AbstractRealScalarFunction a4 = new AbstractRealScalarFunction(4){

            @Override
            public Double evaluate(Vector parameter) {
                return NonlinearFit.computeWeightedRSS(new ACERFunction.ACERParameter(parameter.toArray()), eta, epsilon, weights);
            }
            {
                1 a3;
                super(a2);
            }
        };
        AbstractRealScalarFunction a5 = new AbstractRealScalarFunction(4){

            @Override
            public Double evaluate(Vector parameter) {
                return parameter.get(1);
            }
            {
                2 a3;
                super(a2);
            }
        };
        AbstractRealScalarFunction a6 = new AbstractRealScalarFunction(4){
            {
                3 a3;
                super(a2);
            }

            @Override
            public Double evaluate(Vector parameter) {
                return parameter.get(2) - minLevel;
            }
        };
        AbstractRealScalarFunction a7 = new AbstractRealScalarFunction(4){

            @Override
            public Double evaluate(Vector parameter) {
                return parameter.get(3);
            }
            {
                4 a3;
                super(a2);
            }
        };
        AbstractRealScalarFunction a8 = new AbstractRealScalarFunction(4){

            @Override
            public Double evaluate(Vector parameter) {
                return parameter.get(4);
            }
            {
                5 a3;
                super(a2);
            }
        };
        AbstractRealScalarFunction a9 = new AbstractRealScalarFunction(4){

            @Override
            public Double evaluate(Vector parameter) {
                return a3 - parameter.get(2);
            }
            {
                6 a32;
                super(a2);
            }
        };
        AbstractRealScalarFunction a10 = new AbstractRealScalarFunction(4){
            {
                7 a3;
                super(a2);
            }

            @Override
            public Double evaluate(Vector parameter) {
                return 5.0 - parameter.get(4);
            }
        };
        GeneralGreaterThanConstraints a11 = new GeneralGreaterThanConstraints(a5, a6, a7, a8, a9, a10);
        SQPActiveSetOnlyInequalityConstraintMinimizer a12 = new SQPActiveSetOnlyInequalityConstraintMinimizer(1.0E-8, 1.0E-8, Integer.MAX_VALUE);
        try {
            IterativeMinimizer<Vector> a13 = a12.solve(a4, a11);
            Vector a14 = a13.search((Vector[])new Vector[]{new DenseVector(DoubleArrayMath.max(initial.q(), 0.0), DoubleArrayMath.max(initial.b(), minLevel), DoubleArrayMath.max(initial.a(), 0.0), DoubleArrayMath.max(initial.c(), 0.0))});
            a2 = new ACERFunction.ACERParameter(a14.toArray());
        }
        catch (Exception a15) {
            a2 = initial;
        }
        double a16 = NonlinearFit.computeWeightedRSS(a2, eta, epsilon, weights);
        return new Result(a2, weights, a16);
    }

    public Result fitWithWeights(double[] eta, double[] epsilon, double[] weights, double peakMean, double minLevel, double tailMarker) {
        return this.fitWithWeightsAndInitial(eta, epsilon, weights, enum.fit(eta, epsilon, peakMean), minLevel, tailMarker);
    }

    static {
        Package.validate("EVT");
        enum = new LinearFit();
    }

    public static double computeWeightedRSS(ACERFunction.ACERParameter param, double[] barrierLevels, double[] epsilons, double[] weights) {
        double[] a2 = DoubleArrayMath.log(epsilons);
        return new WeightedRSS(new ACERLogFunction(param)).value(barrierLevels, a2, weights);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Result {
        private final double case;
        private final double[] false;
        private final ACERFunction.ACERParameter enum;

        public double getRSS() {
            return this.case;
        }

        public double[] getWeights() {
            return Arrays.copyOf(this.false, this.false.length);
        }

        private Result(ACERFunction.ACERParameter a2, double[] a3, double a4) {
            Result a5;
            a5.enum = a2;
            a5.false = a3;
            a5.case = a4;
        }

        public ACERFunction.ACERParameter getParameter() {
            return this.enum;
        }
    }
}

