/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.timeseries;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.FrechetDistribution;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.UnivariateEVD;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MARMAModel {
    private final double[] case;
    private final UnivariateEVD false;
    private final double[] enum;

    static {
        Package.validate("EVT");
    }

    private void do(String a2, double[] a3) {
        ArgumentAssertion.assertTrue(DoubleArrayMath.min(a3) >= 0.0, "%s coefficients must be non-negative: %s", a2, a3);
    }

    public int p() {
        return this.case.length;
    }

    public MARMAModel(UnivariateEVD dist) {
        this(new double[0], new double[0], dist);
    }

    public int q() {
        return this.enum.length;
    }

    public double[] MA() {
        return Arrays.copyOf(this.enum, this.enum.length);
    }

    public UnivariateEVD getDistribution() {
        return this.false;
    }

    public MARMAModel(double[] AR, double[] MA, UnivariateEVD dist) {
        this.do("AR", AR);
        this.do("MA", MA);
        this.case = AR;
        this.enum = MA;
        this.false = dist;
    }

    public double[] AR() {
        return Arrays.copyOf(this.case, this.case.length);
    }

    public MARMAModel(double[] AR, double[] MA) {
        this(AR, MA, new FrechetDistribution());
    }
}

