/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.timeseries;

import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayOperation;
import com.numericalmethod.suanshu.number.doublearray.SimpleDoubleArrayOperation;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.random.InverseTransformSamplingEVDRng;
import com.numericalmethod.suanshu.stats.evt.timeseries.MARMAModel;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomNumberGenerator;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MARMASim
implements RandomNumberGenerator {
    private final RandomNumberGenerator super;
    private final MARMAModel char;
    private static final DoubleArrayOperation new;
    private final double[] const;
    private final double[] case;
    private final double[] false;
    private final double[] enum;

    public MARMASim(MARMAModel model, RandomNumberGenerator generator) {
        this(model, generator, new double[model.p()]);
    }

    public MARMASim(MARMAModel model) {
        this(model, new InverseTransformSamplingEVDRng(model.getDistribution()));
    }

    @Override
    public double nextDouble() {
        double[] a2 = new.multiply(this.const, this.enum);
        double[] a3 = new.multiply(this.case, this.false);
        double a4 = this.super.nextDouble();
        double a5 = DoubleArrayMath.max(DoubleArrayMath.max(a2), DoubleArrayMath.max(a3), a4);
        if (this.enum.length > 0) {
            DoubleUtils.rightShift(this.enum);
            this.enum[0] = a5;
        }
        if (this.false.length > 0) {
            DoubleUtils.rightShift(this.false);
            this.false[0] = a4;
        }
        return a5;
    }

    private static double[] do(RandomNumberGenerator a2, int a3) {
        double[] a4 = new double[a3];
        for (int a5 = 0; a5 < a3; ++a5) {
            a4[a5] = a2.nextDouble();
        }
        return a4;
    }

    static {
        Package.validate("EVT");
        new = new SimpleDoubleArrayOperation();
    }

    public MARMASim(MARMAModel model, RandomNumberGenerator generator, double[] initials) {
        this.char = model;
        this.const = model.AR();
        this.case = model.MA();
        this.super = generator;
        this.enum = Arrays.copyOf(DoubleUtils.reverseCopy(initials), model.p());
        this.false = MARMASim.do(generator, model.q());
    }

    @Override
    public void seed(long ... seeds) {
        this.super.seed(seeds);
    }

    public MARMAModel getModel() {
        return this.char;
    }
}

