/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.hmm.mixture.distribution;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;
import com.numericalmethod.suanshu.stats.hmm.mixture.distribution.MixtureDistribution;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.NormalRNG;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MixtureNormalDistribution
implements MixtureDistribution {
    private final Lambda[] case;
    private final boolean false;
    private final boolean enum;

    @Override
    public ProbabilityDistribution[] getDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.case.length];
        for (int a3 = 0; a3 < this.case.length; ++a3) {
            double a4 = this.case[a3].mu;
            double a5 = this.case[a3].sigma;
            a2[a3] = new NormalDistribution(a4, a5);
        }
        return a2;
    }

    public Lambda[] getParams() {
        Lambda[] a2 = Arrays.copyOf(this.case, this.case.length);
        return a2;
    }

    @Override
    public MixtureDistribution newEMDistribution(Object[] param) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param, param.length);
        return new MixtureNormalDistribution(a2, this.enum, this.false);
    }

    public Lambda[] getMStepParams(double[] observations, Matrix u, Object[] param0) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param0, param0.length);
        int a3 = u.nRows();
        int a4 = u.nCols();
        Lambda[] a5 = new Lambda[a2.length];
        for (int a6 = 1; a6 <= a4; ++a6) {
            double a7;
            double a8;
            double a9 = this.case[a6 - 1].mu;
            if (this.enum) {
                a8 = 0.0;
                a7 = 0.0;
                for (int a10 = 1; a10 <= a3; ++a10) {
                    double a11 = u.get(a10, a6);
                    a8 += a11 * observations[a10 - 1];
                    a7 += a11;
                }
                a9 = a8 / a7;
            }
            a8 = this.case[a6 - 1].sigma;
            if (this.false) {
                a7 = 0.0;
                double a12 = 0.0;
                for (int a13 = 1; a13 <= a3; ++a13) {
                    double a14 = u.get(a13, a6);
                    double a15 = observations[a13 - 1] - a9;
                    a7 += a14 * a15 * a15;
                    a12 += a14;
                }
                a8 = Math.sqrt(a7 / a12);
            }
            a5[a6 - 1] = new Lambda(a9, a8);
        }
        return a5;
    }

    public MixtureNormalDistribution(Lambda[] lambda, boolean isMuEstimated, boolean isSigmaEstimated) {
        this.case = Arrays.copyOf(lambda, lambda.length);
        this.enum = isMuEstimated;
        this.false = isSigmaEstimated;
    }

    @Override
    public RandomNumberGenerator[] getRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.case.length];
        for (int a3 = 0; a3 < this.case.length; ++a3) {
            double a4 = this.case[a3].mu;
            double a5 = this.case[a3].sigma;
            a2[a3] = new NormalRNG(a4, a5);
        }
        return a2;
    }

    public MixtureNormalDistribution(Lambda[] lambda) {
        this(lambda, true, true);
    }

    public static class Lambda {
        public final double mu;
        public final double sigma;

        public Lambda(double mu, double sigma) {
            this.mu = mu;
            this.sigma = sigma;
        }
    }
}

