/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.markovchain;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.hmm.HmmInnovation;
import java.util.ArrayList;

public class MCUtils {
    public static Vector getStateCounts(int[] states) {
        int a2 = DoubleArrayMath.max(states);
        double[] a3 = new double[a2];
        for (int a4 : states) {
            int n = a4 - 1;
            a3[n] = a3[n] + 1.0;
        }
        return new DenseVector(a3);
    }

    public static double[] getObservations(HmmInnovation[] innovations, int state) {
        ArrayList<Double> a2 = new ArrayList<Double>();
        for (HmmInnovation a3 : innovations) {
            if (a3.getState() != state) continue;
            a2.add(a3.getObservation());
        }
        return DoubleUtils.collection2DoubleArray(a2);
    }

    static {
        Package.validate("STATS");
    }

    private MCUtils() {
        MCUtils a2;
    }

    public static DenseMatrix getTransitionCounts(int[] states) {
        int a2 = DoubleArrayMath.max(states);
        DenseMatrix a3 = new DenseMatrix(a2, a2);
        for (int a4 = 1; a4 < states.length; ++a4) {
            int a5 = states[a4 - 1];
            int a6 = states[a4];
            a3.set(a5, a6, 1.0 + a3.get(a5, a6));
        }
        return a3;
    }
}

