/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.pca;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.descriptive.correlation.CorrelationMatrix;
import com.numericalmethod.suanshu.stats.descriptive.covariance.SampleCovariance;
import com.numericalmethod.suanshu.stats.pca.PCAImpl;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PCAbyEigen
extends PCAImpl {
    private final boolean const;
    private Matrix case = null;
    private final ImmutableMatrix false;
    private Eigen enum = null;

    @Override
    public Vector loading(int i) {
        double[] a2 = this.eigen().getRealEigenvalues();
        int a3 = a2.length;
        ArgumentAssertion.assertTrue(i >= 1 && i <= a3, "out-of-range [1, %d] loading index %d", a3, i);
        int a4 = this.nFactors();
        if (i <= a4) {
            return this.eigen().getProperty(i - 1).eigenVector();
        }
        return new SparseVector(a4);
    }

    public PCAbyEigen(Matrix data, boolean correlation) {
        this(data, correlation, null);
    }

    @Override
    public Vector proportionVar() {
        Vector a2 = this.sdPrincipalComponents();
        double a3 = MatrixMeasure.tr(this.V());
        int a4 = a2.size();
        double[] a5 = new double[a4];
        for (int a6 = 0; a6 < a4; ++a6) {
            a5[a6] = a2.get(a6 + 1) * a2.get(a6 + 1);
        }
        return new DenseVector(a5).scaled(1.0 / a3);
    }

    @Override
    public Vector scale() {
        if (this.const) {
            return super.scale();
        }
        return new DenseVector(DoubleUtils.rep(1.0, this.nFactors()));
    }

    public Eigen eigen() {
        if (this.enum == null) {
            this.enum = new Eigen(this.V(), Eigen.Method.SYMMETRY);
        }
        return this.enum;
    }

    public PCAbyEigen(Matrix data, boolean correlation, Matrix V) {
        super(data);
        if (V != null) {
            ArgumentAssertion.assertTrue(V.nCols() == this.nFactors() && V.nRows() == this.nFactors(), "V is a p*p square matrix, where p is the number of columns of data", new Object[0]);
        }
        this.const = correlation;
        this.false = V != null ? new ImmutableMatrix(V) : null;
    }

    public Matrix V() {
        if (this.false != null) {
            return this.false;
        }
        if (this.case != null) {
            return this.case;
        }
        this.case = this.const ? new CorrelationMatrix((Matrix)new SampleCovariance(this.X())) : new SampleCovariance(this.X());
        return this.case;
    }

    public PCAbyEigen(Matrix data) {
        this(data, true);
    }

    @Override
    public Vector sdPrincipalComponents() {
        double[] a2 = this.eigen().getRealEigenvalues();
        double[] a3 = DoubleArrayMath.sqrt(a2);
        return new DenseVector(a3);
    }

    @Override
    public Matrix loadings() {
        double[] a2 = this.eigen().getRealEigenvalues();
        int a3 = a2.length;
        ArrayList<Vector> a4 = new ArrayList<Vector>(a3);
        for (int a5 = 1; a5 <= a3; ++a5) {
            a4.add(this.loading(a5));
        }
        return MatrixFactory.cbind(a4);
    }
}

