/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.rng.multivariate;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyWang2006;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.IID;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.RandomVectorGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.RandomStandardNormalGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.StandardNormalRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NormalRVG
implements RandomVectorGenerator {
    private final Impl false;
    private final IID enum;

    public NormalRVG(int dim) {
        this.enum = new IID(new StandardNormalRNG(), dim);
        this.false = new Impl(){
            {
                3 a2;
            }

            @Override
            public double[] nextVector() {
                return NormalRVG.this.enum.nextVector();
            }
        };
    }

    public NormalRVG(Vector mu, Matrix sigma) {
        this(mu, sigma, new StandardNormalRNG());
    }

    public NormalRVG(Vector mu, Matrix sigma, RandomStandardNormalGenerator rnorm) {
        this(mu, sigma, PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(sigma)), rnorm);
    }

    @Override
    public void seed(long ... seeds) {
        this.enum.seed(seeds);
    }

    public NormalRVG(final Vector mu, Matrix sigma, double epsilon, RandomStandardNormalGenerator rnorm) {
        ArgumentAssertion.assertTrue(sigma.nRows() == mu.size() && sigma.nCols() == mu.size(), "sigma should be a square matrix of dimension mu.size() by mu.size()", new Object[0]);
        int a2 = mu.size();
        final ImmutableMatrix a3 = new ImmutableMatrix(new CholeskyWang2006(sigma, epsilon).L());
        this.enum = new IID(rnorm, a2);
        this.false = MatrixPropertyUtils.isZero(mu, epsilon) ? new Impl(){
            {
                1 a2;
            }

            @Override
            public double[] nextVector() {
                DenseVector a2 = new DenseVector(NormalRVG.this.enum.nextVector());
                Vector a32 = a3.multiply(a2);
                return a32.toArray();
            }
        } : new Impl(){
            {
                2 a2;
            }

            @Override
            public double[] nextVector() {
                DenseVector a2 = new DenseVector(NormalRVG.this.enum.nextVector());
                Vector a32 = mu.add(a3.multiply(a2));
                return a32.toArray();
            }
        };
    }

    @Override
    public double[] nextVector() {
        return this.false.nextVector();
    }

    private static interface Impl {
        public double[] nextVector();
    }
}

