/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.rng.multivariate.mcmc.metropolis;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.mcmc.metropolis.AbstractMetropolis;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.mcmc.metropolis.MetropolisUtils;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.mcmc.proposalfunction.ProposalFunction;
import com.numericalmethod.suanshu.stats.random.rng.univariate.BernoulliTrial;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomNumberGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MetropolisHastings
extends AbstractMetropolis {
    private final RandomNumberGenerator const;
    private final ProposalFunction case;
    private final ProposalDensityFunction false;
    private final RealScalarFunction enum;

    public MetropolisHastings(RealScalarFunction logf, ProposalFunction proposalFunction, ProposalDensityFunction proposalDensity, Vector initialState, RandomNumberGenerator rng) {
        super(initialState, rng);
        this.enum = logf;
        this.case = proposalFunction;
        this.false = proposalDensity;
        this.const = rng;
    }

    @Override
    protected Vector nextProposedState(Vector currentState) {
        return (Vector)this.case.evaluate(currentState);
    }

    @Override
    protected boolean isProposalAccepted(Vector x, Vector y) {
        double a2 = MetropolisUtils.logAcceptanceRatio(this.enum, x, y) + (Math.log(this.false.evaluate(y, x)) - Math.log(this.false.evaluate(x, y)));
        return BernoulliTrial.nextLogTrial(this.const, a2);
    }

    public static interface ProposalDensityFunction {
        public double evaluate(Vector var1, Vector var2);
    }
}

