/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.rng.univariate.gamma;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.random.rng.RNGUtils;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.gamma.RandomGammaGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.RandomStandardNormalGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MarsagliaTsang2000
implements RandomGammaGenerator {
    private final Generate const;
    private final double case;
    private final RandomLongGenerator false;
    private final RandomStandardNormalGenerator enum;

    @Override
    public void seed(long ... seeds) {
        this.enum.seed(seeds);
        this.false.seed(seeds);
    }

    @Override
    public double nextDouble() {
        return this.const.nextDouble();
    }

    public MarsagliaTsang2000(double k2, double theta) {
        this(k2, theta, RNGUtils.RNORM, RNGUtils.UNIFORM);
    }

    public MarsagliaTsang2000(double k2, double theta, RandomStandardNormalGenerator normal, RandomLongGenerator uniform) {
        ArgumentAssertion.assertPositive(k2, "shape parameter");
        ArgumentAssertion.assertPositive(theta, "scale parameter");
        this.case = theta;
        this.enum = normal;
        this.false = uniform;
        this.const = k2 >= 1.0 ? new Kg1(k2) : new Kl1(k2);
    }

    public MarsagliaTsang2000() {
        this(1.0, 1.0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Kl1
    implements Generate {
        private final double false;
        private final Kg1 enum;

        private Kl1(double a2) {
            Kl1 a3;
            a3.enum = new Kg1(a2 + 1.0);
            a3.false = 1.0 / a2;
        }

        @Override
        public double nextDouble() {
            double a2 = this.enum.nextDouble();
            double a3 = MarsagliaTsang2000.this.false.nextDouble();
            double a4 = Math.pow(a3, this.false);
            return a4 *= a2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Kg1
    implements Generate {
        private final double false;
        private final double enum;

        private Kg1(double a2) {
            Kg1 a3;
            a3.enum = a2 - 0.3333333333333333;
            a3.false = 1.0 / Math.sqrt(9.0 * a3.enum);
        }

        @Override
        public double nextDouble() {
            double a2;
            while (true) {
                double a3;
                double a4;
                double a5;
                if ((a2 = 1.0 + this.false * (a5 = MarsagliaTsang2000.this.enum.nextDouble())) <= 0.0) {
                    continue;
                }
                a2 = a2 * a2 * a2;
                double a6 = MarsagliaTsang2000.this.false.nextDouble();
                if (a6 < 1.0 - 0.0331 * (a4 = (a3 = a5 * a5) * a3)) {
                    return this.enum * a2 * MarsagliaTsang2000.this.case;
                }
                if (Math.log(a6) < 0.5 * a3 + this.enum * (1.0 - a2 + Math.log(a2))) break;
            }
            return this.enum * a2 * MarsagliaTsang2000.this.case;
        }
    }

    private static interface Generate {
        public double nextDouble();
    }
}

