/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.linear;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.linear.LinearCongruentialGenerator;
import java.util.concurrent.atomic.AtomicLong;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Lehmer
implements LinearCongruentialGenerator {
    private final long new;
    private final long const;
    private final long case;
    private AtomicLong false = new AtomicLong();
    private final long enum;

    @Override
    public long modulus() {
        return this.case;
    }

    @Override
    public int order() {
        return 1;
    }

    public Lehmer(long a2, long m2, long seed) {
        ArgumentAssertion.assertPositive(a2, "a");
        ArgumentAssertion.assertPositive(m2, "m");
        this.enum = a2;
        this.case = m2;
        this.const = m2 / a2;
        this.new = m2 % a2;
        ArgumentAssertion.assertTrue(this.new <= this.const, "the (a, m) combination is not valid; try a <= sqrt(m)", new Object[0]);
        this.seed(seed);
    }

    @Override
    public double nextDouble() {
        return (double)this.nextLong() / (double)this.case;
    }

    @Override
    public void seed(long ... seeds) {
        this.false.set(seeds[0] % this.case);
    }

    @Override
    public long nextLong() {
        long a2;
        long a3;
        do {
            a2 = a3 = this.false.get();
            long a4 = a2 / this.const;
            if ((a2 = this.enum * (a2 - a4 * this.const) - a4 * this.new) >= 0L) continue;
            a2 += this.case;
        } while (!this.false.compareAndSet(a3, a2));
        return a2;
    }

    public Lehmer() {
        this(40014L, 2147483563L, 8682522807148012L + System.nanoTime());
    }

    public Lehmer(long a2, long m2, long k2, long seed) {
        this(FunctionOps.modpow(a2, k2, m2), m2, seed);
    }
}

