/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LMProblem {
    private final ImmutableMatrix super;
    private final boolean char;
    private final ImmutableVector new;
    private final ImmutableVector const;
    private final ImmutableVector case;
    private volatile ImmutableMatrix false = null;
    private final ImmutableMatrix enum;

    public int nObs() {
        return this.enum.nRows();
    }

    public LMProblem(Vector y, Matrix X, boolean intercept) {
        this(y, X, intercept, null);
    }

    public int nFactors() {
        return this.enum.nCols();
    }

    protected void checkInputs() {
        ArgumentAssertion.assertTrue(this.const.size() == this.enum.nRows(), "y and A do not have the same number of rows", new Object[0]);
        if (this.case != null) {
            ArgumentAssertion.assertTrue(this.case.size() == this.const.size(), "weights and y do not have the same number of rows", new Object[0]);
            for (int a2 = 1; a2 <= this.case.size(); ++a2) {
                ArgumentAssertion.assertTrue(this.case.get(a2) >= 0.0, "all weights must be non negative", new Object[0]);
            }
        }
    }

    public LMProblem(Vector y, Matrix X, boolean intercept, Vector weights) {
        this.const = !(y instanceof ImmutableVector) ? new ImmutableVector(y) : (ImmutableVector)y;
        this.char = intercept;
        this.enum = new ImmutableMatrix(!intercept ? X : MatrixFactory.cbind(X, new DenseMatrix(DoubleUtils.rep(1.0, X.nRows()), X.nRows(), 1)));
        ImmutableVector immutableVector = weights != null ? (!(weights instanceof ImmutableVector) ? new ImmutableVector(weights) : (ImmutableVector)weights) : (this.case = null);
        if (weights != null) {
            Vector a2 = weights.pow(0.5);
            DiagonalMatrix a3 = new DiagonalMatrix(a2.toArray());
            this.super = new ImmutableMatrix(a3.multiply(this.enum));
            this.new = new ImmutableVector(y.multiply(a2));
        } else {
            this.super = this.enum;
            this.new = this.const;
        }
        this.checkInputs();
    }

    public ImmutableVector wy() {
        return this.new;
    }

    public ImmutableMatrix A() {
        return this.enum;
    }

    public LMProblem(Vector y, Matrix X, Vector weights) {
        this(y, X, true, weights);
    }

    public ImmutableMatrix invOfwAtwA() {
        if (this.false == null) {
            this.false = new ImmutableMatrix(new Inverse(this.super.t().multiply(this.super)));
        }
        return this.false;
    }

    public LMProblem(LMProblem that) {
        this.const = new ImmutableVector(that.const);
        this.enum = new ImmutableMatrix(that.enum);
        this.new = new ImmutableVector(that.new);
        this.super = new ImmutableMatrix(that.super);
        this.char = that.char;
        this.case = that.case == null ? null : new ImmutableVector(that.case);
    }

    public ImmutableMatrix wA() {
        return this.super;
    }

    public boolean intercept() {
        return this.char;
    }

    public ImmutableVector y() {
        return this.const;
    }

    public int nExogenousFactors() {
        return this.enum.nCols() - (this.char ? 1 : 0);
    }

    public LMProblem(Vector y, Matrix X) {
        this(y, X, true, null);
    }

    public ImmutableMatrix X() {
        Matrix a2 = !this.char ? this.enum : new SubMatrixRef(this.enum, 1, this.enum.nRows(), 1, this.enum.nCols() - 1);
        return new ImmutableMatrix(a2);
    }

    public ImmutableVector weights() {
        return this.case;
    }
}

