/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.modelselection;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GLMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GeneralizedLinearModel;
import java.util.Arrays;

public abstract class SingleFactorSelection {
    protected final GLMProblem problem;
    protected int[] subset;
    protected final double criticalValue;
    protected int[] flags;

    public SingleFactorSelection(GLMProblem problem, double significance) {
        ArgumentAssertion.assertRange(significance, 0.0, 1.0, "significance level");
        this.problem = problem;
        this.criticalValue = new NormalDistribution(0.0, 1.0).quantile(1.0 - significance / 2.0);
    }

    protected Matrix subA() {
        this.subset = DoubleUtils.select(this.flags, new DoubleUtils.which(){

            @Override
            public boolean isTrue(double x, int index) {
                return x > 0.0;
            }
            {
                1 a2;
            }
        });
        Matrix a2 = this.subset.length > 0 ? MatrixFactory.columns(this.problem.A(), this.subset) : null;
        return a2;
    }

    protected boolean isSelected(int factorIndex) {
        return this.flags[factorIndex - 1] > 0;
    }

    public int[] getFlags() {
        return Arrays.copyOf(this.flags, this.flags.length);
    }

    public GeneralizedLinearModel getModel() throws ModelNotFound {
        Matrix a2 = this.subA();
        if (a2 == null) {
            throw new ModelNotFound("no factor selected");
        }
        GLMProblem a3 = new GLMProblem((Vector)this.problem.y(), a2, this.problem.intercept(), this.problem.getFamily());
        GeneralizedLinearModel a4 = new GeneralizedLinearModel(a3);
        return a4;
    }

    public static class ModelNotFound
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ModelNotFound(String msg) {
            super(msg);
        }
    }
}

