/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.lasso.lars;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.qr.QR;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.BackwardSubstitution;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.ForwardSubstitution;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.DeepCopyable;
import com.numericalmethod.suanshu.misc.algorithm.ActiveSet;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.descriptive.rank.Min;
import com.numericalmethod.suanshu.stats.regression.linear.lasso.lars.LARSProblem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LARSFitting {
    private final int case;
    private final double false;
    private final LARSProblem enum;

    public LARSFitting(LARSProblem problem, int maxIterations) {
        this(problem, 10.0 * Constants.EPSILON, maxIterations);
    }

    private boolean do() {
        LARSFitting a2;
        ArgumentAssertion.assertPositive(a2.enum.nObs(), "n > 0");
        ArgumentAssertion.assertPositive(a2.enum.m(), "m > 0");
        Vector a3 = a2.enum.XL2Norm();
        for (int a4 = 1; a4 <= a2.enum.m(); ++a4) {
            ArgumentAssertion.assertTrue(a3.get(a4) > a2.false * Math.sqrt(a2.enum.nObs()), "at least one of the predictors is effectively 0; remove such column(s) from the predictors", new Object[0]);
        }
        return true;
    }

    public Estimators getEstimators() {
        Object a2;
        double a3;
        this.do();
        int a4 = this.enum.nObs();
        int a5 = this.enum.m();
        boolean a6 = this.enum.isLASSO();
        Matrix a7 = this.enum.XLARS();
        Vector a8 = this.enum.yLARS();
        Matrix a9 = a7.t().multiply(a7);
        Vector a10 = a7.t().multiply(a8);
        ActiveSet a11 = new ActiveSet(false);
        a11.addInactive(DoubleUtils.seq(1, a5));
        ArrayList<Integer> a12 = new ArrayList<Integer>();
        int a13 = 0;
        UpperTriangularMatrix a14 = null;
        ArrayList<DenseVector> a15 = new ArrayList<DenseVector>();
        a15.add(new DenseVector(a5));
        ArrayList<Double> a16 = new ArrayList<Double>();
        ArrayList<Double> a17 = new ArrayList<Double>();
        ArrayList<Double> a18 = new ArrayList<Double>();
        ArrayList<Integer> a19 = new ArrayList<Integer>();
        int a20 = 0;
        while (a11.activeSize() < a5 && a20 < this.case && !((a3 = (a2 = VectorFactory.subVector(a10, a11.getInactiveIndices())).norm(Double.POSITIVE_INFINITY)) < 10.0 * this.false)) {
            int a21;
            DenseVector a22;
            int a23;
            DeepCopyable a24;
            double a25;
            ++a20;
            int a26 = -a13;
            if (a13 == 0) {
                int a27 = 1 + DoubleUtils.maxIndex(DoubleArrayMath.abs(a2.toArray()));
                int a28 = a11.getInactive(a27);
                a2 = VectorFactory.subVector((Vector)a2, LARSFitting.do(DoubleUtils.seq(1, a2.size()), a27));
                a14 = LARSFitting.do(a14, VectorFactory.subVector(a9.getRow(a28), a11.getActiveIndices()), a9.get(a28, a28));
                a26 = a28;
                a11.addActive(a28);
                a12.add(a10.get(a28) > 0.0 ? 1 : -1);
            }
            DenseVector a29 = new DenseVector(DoubleUtils.collection2IntArray(a12));
            Vector a30 = new ForwardSubstitution().solve((LowerTriangularMatrix)a14.t(), a29);
            Vector a31 = new BackwardSubstitution().solve(a14, a30);
            double a32 = 0.0;
            for (int a33 = 1; a33 <= a31.size(); ++a33) {
                a32 += a31.get(a33) * a29.get(a33);
            }
            double a34 = 1.0 / Math.sqrt(a32);
            Vector a35 = a31.scaled(a34);
            if (a11.activeSize() >= Math.min(a5, a4)) {
                a25 = a3 / a34;
            } else {
                a24 = new SubMatrixRef(a9, a11.getActiveIndices(), a11.getInactiveIndices());
                Vector a36 = a24.t().multiply(a35);
                a23 = a36.size();
                a22 = new DenseVector(2 * a23 + 1);
                for (a21 = 1; a21 <= a23; ++a21) {
                    a22.set(2 * a21 - 1, (a3 - a2.get(a21)) / (a34 - a36.get(a21)));
                    a22.set(2 * a21, (a3 + a2.get(a21)) / (a34 + a36.get(a21)));
                }
                a22.set(2 * a23 + 1, a3 / a34);
                for (a21 = 1; a21 <= a22.size(); ++a21) {
                    if (!(a22.get(a21) <= 0.0)) continue;
                    a22.set(a21, Double.MAX_VALUE);
                }
                a25 = new Min(a22.toArray()).value();
            }
            a24 = a15.size() > 0 ? (Vector)a15.get(a15.size() - 1) : new DenseVector(a5);
            int a37 = 0;
            if (a6) {
                a23 = a11.activeSize();
                a22 = new DenseVector(a23 + 1);
                for (a21 = 1; a21 <= a23; ++a21) {
                    double a38 = -a24.get(a11.getActive(a21)) / a35.get(a21);
                    a22.set(a21, a38 > 0.0 ? a38 : Double.MAX_VALUE);
                }
                a22.set(a23 + 1, a25);
                double a39 = a22.norm(Double.NEGATIVE_INFINITY);
                a13 = 0;
                a37 = 0;
                if (a39 < a25) {
                    a25 = a39;
                    a37 = 1 + DoubleUtils.minIndex(DoubleArrayMath.abs(a22.toArray()));
                    a13 = a11.getActive(a37);
                }
            }
            a16.add(a3);
            a17.add(a25);
            a18.add(a34);
            a19.add(a26);
            Vector a40 = new SubMatrixRef(a9, DoubleUtils.seq(1, a5), a11.getActiveIndices()).multiply(a35).scaled(a25);
            a10 = a10.minus(a40);
            a22 = new DenseVector(a5);
            for (a21 = 1; a21 <= a5; ++a21) {
                a22.set(a21, a24.get(a21));
            }
            for (a21 = 1; a21 <= a11.activeSize(); ++a21) {
                a22.set(a11.getActive(a21), a22.get(a11.getActive(a21)) + a25 * a35.get(a21));
            }
            if (a6 && a13 != 0) {
                a14 = LARSFitting.do(a14, a37);
                a22.set(a13, 0.0);
                a11.removeActive(a13);
                a12.set(a37 - 1, 0);
                a12.remove((Object)0);
            }
            a15.add(a22);
        }
        a2 = new Estimators(this.enum, a15, a16, a17, a18, a19);
        return a2;
    }

    private static int[] do(int[] a2, int a3) {
        List<Integer> a4 = DoubleUtils.intArray2List(a2);
        a4.remove((Object)a3);
        return DoubleUtils.collection2IntArray(a4);
    }

    public LARSFitting(LARSProblem problem) {
        this(problem, 10 * Math.min(problem.m(), problem.nObs()));
    }

    private static UpperTriangularMatrix do(UpperTriangularMatrix a2, int a3) {
        int[] a4 = DoubleUtils.seq(1, a2.nRows());
        int[] a5 = LARSFitting.do(a4, a3);
        UpperTriangularMatrix a6 = null;
        if (a5.length > 0) {
            SubMatrixRef a7 = new SubMatrixRef(a2, a4, a5);
            a6 = new QR(a7).R();
        }
        return a6;
    }

    private static UpperTriangularMatrix do(UpperTriangularMatrix a2, Vector a3, double a4) {
        if (a2 == null) {
            double a5 = Math.sqrt(a4);
            UpperTriangularMatrix a6 = new UpperTriangularMatrix(new double[][]{{a5}});
            return a6;
        }
        Vector a7 = new ForwardSubstitution().solve((LowerTriangularMatrix)a2.t(), a3);
        double a8 = 0.0;
        for (int a9 = 1; a9 <= a7.size(); ++a9) {
            a8 += a7.get(a9) * a7.get(a9);
        }
        double a10 = a4 - a8;
        a10 = a10 <= Constants.EPSILON ? Constants.EPSILON : Math.sqrt(a10);
        int a11 = a2.nRows() + 1;
        Matrix a12 = a2;
        a12 = MatrixFactory.cbind(a12, new DenseMatrix(a7));
        a12 = MatrixFactory.rbind(a12, new DenseMatrix(DoubleUtils.rep(0.0, a11), 1, a11));
        a12.set(a11, a11, a10);
        UpperTriangularMatrix a13 = new UpperTriangularMatrix(a12);
        return a13;
    }

    public LARSFitting(LARSProblem problem, double epsilon, int maxIterations) {
        this.enum = problem;
        this.false = epsilon;
        this.case = maxIterations;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Estimators {
        private final Vector char;
        private final List<Double> new;
        private final List<Integer> const;
        private final List<Double> case;
        private final List<Vector> false;
        private final List<Double> enum;

        public List<Vector> betas() {
            return Collections.unmodifiableList(this.false);
        }

        private Estimators(LARSProblem a2, List<Vector> a3, List<Double> a4, List<Double> a5, List<Double> a6, List<Integer> a7) {
            Estimators a8;
            a8.false = new ArrayList<Vector>(a3);
            a8.new = new ArrayList<Double>(a4);
            a8.case = new ArrayList<Double>(a5);
            a8.enum = new ArrayList<Double>(a6);
            a8.const = new ArrayList<Integer>(a7);
            a8.char = a2.XL2Norm();
        }

        public List<Double> gamma() {
            return Collections.unmodifiableList(this.case);
        }

        public List<Double> A() {
            return Collections.unmodifiableList(this.enum);
        }

        public List<Double> max_abs_cor() {
            return Collections.unmodifiableList(this.new);
        }

        public List<Integer> actions() {
            return Collections.unmodifiableList(this.const);
        }

        public Matrix betaMatrix() {
            int a2 = this.false.size();
            int a3 = this.false.get(0).size();
            Vector[] a4 = new Vector[a2];
            for (int a5 = 1; a5 <= a2; ++a5) {
                a4[a5 - 1] = this.false.get(a5 - 1);
                for (int a6 = 1; a6 <= a3; ++a6) {
                    a4[a5 - 1].set(a6, a4[a5 - 1].get(a6) / this.char.get(a6));
                }
            }
            Matrix a7 = MatrixFactory.rbind(a4);
            return a7;
        }
    }
}

