/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.logistic;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractRealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.MultivariateMaximizer;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblemImpl;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.LinearModel;
import com.numericalmethod.suanshu.stats.regression.linear.logistic.LogisticBeta;
import com.numericalmethod.suanshu.stats.regression.linear.logistic.LogisticProblem;
import com.numericalmethod.suanshu.stats.regression.linear.logistic.LogisticResiduals;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSRegression;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogisticRegression
implements LinearModel {
    private final ImmutableVector false;
    private final LogisticProblem enum;

    @Override
    public double Ey(Vector x) {
        return OLSRegression.Ey(this.false, x, this.enum.intercept());
    }

    @Override
    public LogisticBeta beta() {
        LogisticBeta a2 = new LogisticBeta(this.false, (LogisticResiduals)this.residuals());
        return a2;
    }

    public static RealScalarFunction logLikelihood(final LogisticProblem problem) {
        return new AbstractRealScalarFunction(problem.nFactors()){
            {
                1 a3;
                super(a2);
            }

            @Override
            public Double evaluate(Vector b2) {
                Vector a2 = problem.A().multiply(b2);
                double a3 = 0.0;
                for (int a4 = 1; a4 <= problem.nObs(); ++a4) {
                    a3 += problem.y().get(a4) * a2.get(a4) - Math.log(1.0 + Math.exp(a2.get(a4)));
                }
                return a3;
            }
        };
    }

    public double AIC() {
        int a2 = this.enum.nFactors();
        double a3 = (double)(2 * a2) - 2.0 * this.ML();
        return a3;
    }

    public LogisticRegression(LogisticProblem problem) {
        this.enum = problem;
        try {
            int a2 = problem.nFactors();
            RealScalarFunction a3 = LogisticRegression.logLikelihood(this.enum);
            MultivariateMaximizer a4 = new MultivariateMaximizer(0.0, 200);
            MultivariateMaximizer.Solution a5 = a4.solve(new C2OptimProblemImpl(a3));
            this.false = new ImmutableVector(a5.search(new DenseVector(a2)));
        }
        catch (Exception a6) {
            throw new RuntimeException("cannot compute betaHat");
        }
    }

    @Override
    public LogisticResiduals residuals() {
        LogisticResiduals a2 = new LogisticResiduals(this.enum, (Vector)this.false);
        return a2;
    }

    public LogisticRegression(LMProblem problem) {
        this(new LogisticProblem(problem));
    }

    public double ML() {
        RealScalarFunction a2 = LogisticRegression.logLikelihood(this.enum);
        double a3 = (Double)a2.evaluate(this.false);
        return a3;
    }
}

