/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.logistic;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.GLMBinomial;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.GLMFamily;
import com.numericalmethod.suanshu.stats.regression.linear.logistic.LogisticProblem;
import com.numericalmethod.suanshu.stats.regression.linear.logistic.LogisticRegression;
import com.numericalmethod.suanshu.stats.regression.linear.residualanalysis.LMResiduals;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogisticResiduals
extends LMResiduals {
    private final ImmutableVector enum;

    public ImmutableVector devianceResiduals() {
        int a2 = this.getProblem().y().size();
        GLMFamily a3 = new GLMFamily(new GLMBinomial());
        double[] a4 = new double[a2];
        for (int a5 = 1; a5 <= a2; ++a5) {
            double a6 = this.getProblem().y().get(a5);
            double a7 = this.fitted().get(a5);
            double a8 = a3.distribution().deviance(a6, a7);
            a4[a5 - 1] = a6 > a7 ? Math.sqrt(a8) : -Math.sqrt(a8);
        }
        DenseVector a9 = new DenseVector(a4);
        return new ImmutableVector(a9);
    }

    public double deviance() {
        RealScalarFunction a2 = LogisticRegression.logLikelihood((LogisticProblem)this.getProblem());
        double a3 = (Double)a2.evaluate(this.enum);
        double a4 = -2.0 * a3;
        return a4;
    }

    public double nullDeviance() {
        int a2 = this.getProblem().nFactors();
        RealScalarFunction a3 = LogisticRegression.logLikelihood((LogisticProblem)this.getProblem());
        double a4 = new Mean(this.getProblem().y().toArray()).value();
        double a5 = Math.log(a4 / (1.0 - a4));
        double[] a6 = DoubleUtils.rep(0.0, a2);
        a6[a2 - 1] = a5;
        double a7 = -2.0 * (Double)a3.evaluate(new DenseVector(a6));
        return a7;
    }

    private static Vector do(Vector a2) {
        return VectorFactory.foreach(a2, (UnivariateRealFunction)new AbstractUnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return 1.0 / (1.0 + Math.exp(-x));
            }
        });
    }

    LogisticResiduals(LogisticProblem a2, Vector a3) {
        super(a2, LogisticResiduals.do(a2.A().multiply(a3)));
        LogisticResiduals a4;
        a4.enum = new ImmutableVector(a3);
    }
}

