/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.ols;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.OLSSolver;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.LinearModel;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSBeta;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSResiduals;
import com.numericalmethod.suanshu.stats.regression.linear.residualanalysis.LMDiagnostics;
import com.numericalmethod.suanshu.stats.regression.linear.residualanalysis.LMInformationCriteria;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OLSRegression
implements LinearModel {
    private final ImmutableVector false;
    private final LMProblem enum;

    public OLSRegression(LMProblem problem, double epsilon) {
        this.enum = problem;
        OLSSolver a2 = new OLSSolver(epsilon);
        this.false = new ImmutableVector(a2.solve(new LSProblem(problem.wA(), problem.wy())));
    }

    public static double Ey(Vector beta, Vector x, boolean intercept) {
        Vector a2 = intercept ? VectorFactory.concat(x, new DenseVector(1.0)) : x;
        double a3 = beta.innerProduct(a2);
        return a3;
    }

    @Override
    public double Ey(Vector x) {
        return OLSRegression.Ey(this.false, x, this.enum.intercept());
    }

    @Override
    public OLSResiduals residuals() {
        OLSResiduals a2 = new OLSResiduals(this.enum, this.false);
        return a2;
    }

    public LMDiagnostics diagnostics() {
        return new LMDiagnostics(this.residuals());
    }

    @Override
    public OLSBeta beta() {
        return new OLSBeta(this.false, this.residuals());
    }

    public LMInformationCriteria informationCriteria() {
        return new LMInformationCriteria(this.residuals());
    }

    public OLSRegression(LMProblem problem) {
        this(problem, PrecisionUtils.autoEpsilon(problem.wA()));
    }
}

