/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.process.ou;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.process.ou.OUFitting;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.process.ou.OrnsteinUhlenbeckProcess;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OUFittingMLE
implements OUFitting {
    private final boolean enum;

    public OUFittingMLE() {
        this(true);
    }

    public OUFittingMLE(boolean estimateVolatility) {
        this.enum = estimateVolatility;
    }

    public OrnsteinUhlenbeckProcess getFittedOU(double[] ts) {
        return this.getFittedOU(ts, 1.0);
    }

    @Override
    public OrnsteinUhlenbeckProcess getFittedOU(double[] ts, double dt) {
        int a2 = ts.length;
        ArgumentAssertion.assertTrue(a2 > 1, "in order to fit an OU process, the time series should contain at least two data points", new Object[0]);
        double[] a3 = Arrays.copyOfRange(ts, 1, a2);
        double[] a4 = Arrays.copyOfRange(ts, 0, a2 - 1);
        double a5 = 0.0;
        double a6 = 0.0;
        double a7 = 0.0;
        double a8 = 0.0;
        double a9 = 0.0;
        for (int a10 = 0; a10 < a2 - 1; ++a10) {
            a5 += a4[a10];
            a6 += a3[a10];
            a7 += a4[a10] * a4[a10];
            a8 += a4[a10] * a3[a10];
            a9 += a3[a10] * a3[a10];
        }
        double a11 = (a6 * a7 - a5 * a8) / ((double)(a2 - 1) * (a7 - a8) - (a5 * a5 - a5 * a6));
        double a12 = -(1.0 / dt) * Math.log((a8 - a11 * a5 - a11 * a6 + (double)(a2 - 1) * a11 * a11) / (a7 - 2.0 * a11 * a5 + (double)(a2 - 1) * a11 * a11));
        double a13 = 1.0;
        if (this.enum) {
            double a14 = Math.exp(-(a12 * dt));
            double a15 = Math.sqrt(1.0 / (double)(a2 - 1) * (a9 - 2.0 * a14 * a8 + a14 * a14 * a7 - 2.0 * a11 * (1.0 - a14) * (a6 - a14 * a5) + (double)(a2 - 1) * a11 * a11 * (1.0 - a14) * (1.0 - a14)));
            a13 = a15 * Math.sqrt(2.0 * a12 / (1.0 - a14 * a14));
        }
        OrnsteinUhlenbeckProcess a16 = new OrnsteinUhlenbeckProcess(a11, a12, a13);
        return a16;
    }
}

