/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.distribution.kolmogorov;

import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;
import com.numericalmethod.suanshu.stats.test.distribution.kolmogorov.KolmogorovDistribution;
import com.numericalmethod.suanshu.stats.test.distribution.kolmogorov.KolmogorovOneSidedDistribution;
import com.numericalmethod.suanshu.stats.test.distribution.kolmogorov.KolmogorovSmirnov;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class KolmogorovSmirnov1Sample
extends KolmogorovSmirnov {
    private final int enum;

    public KolmogorovSmirnov1Sample(double[] sample, ProbabilityDistribution F2, KolmogorovSmirnov.Side side) {
        super((double[][])new double[][]{sample}, side, KolmogorovSmirnov.Type.ONE_SAMPLE);
        this.enum = sample.length;
        this.ties = DoubleUtils.hasDuplicate(sample, 0.0);
        double[] a2 = Arrays.copyOf(sample, sample.length);
        Arrays.sort(a2);
        double[] a3 = new double[a2.length];
        for (int a4 = 0; a4 < a2.length; ++a4) {
            a3[a4] = F2.cdf(a2[a4]) - (double)a4 / (double)this.enum;
        }
        double a5 = Double.NEGATIVE_INFINITY;
        for (int a6 = 0; a6 < a3.length; ++a6) {
            double a7 = 1.0 / (double)this.enum - a3[a6];
            a5 = a7 > a5 ? a7 : a5;
        }
        this.Dnp = a5;
        this.Dnn = DoubleArrayMath.max(a3);
        this.Dn = DoubleArrayMath.max(this.Dnp, this.Dnn);
    }

    @Override
    public double pValue() {
        double a2 = this.statistics();
        double a3 = Double.NaN;
        switch (this.side) {
            case TWO_SIDED: {
                a3 = KolmogorovSmirnov1Sample.oneSidedPvalue(new KolmogorovDistribution(this.enum, this.ties ? 0 : 16000, false), a2);
                break;
            }
            case GREATER: {
                a3 = KolmogorovSmirnov1Sample.oneSidedPvalue(new KolmogorovOneSidedDistribution(this.enum, this.ties ? 0 : 50), a2);
                break;
            }
            case LESS: {
                a3 = KolmogorovSmirnov1Sample.oneSidedPvalue(new KolmogorovOneSidedDistribution(this.enum, this.ties ? 0 : 50), a2);
            }
        }
        return a3;
    }

    @Override
    public double statistics() {
        switch (this.side) {
            case TWO_SIDED: {
                return this.Dn;
            }
            case GREATER: {
                return this.Dnp;
            }
            case LESS: {
                return this.Dnn;
            }
        }
        throw new RuntimeException("logical error");
    }
}

