/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.rank.wilcoxon;

import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.descriptive.rank.Rank;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.stats.test.rank.wilcoxon.WilcoxonRankSumDistribution;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WilcoxonRankSum
extends HypothesisTest {
    private double do;
    private final WilcoxonRankSumDistribution long;
    private final double super;
    private final boolean char;
    private final int new;
    private final int const;
    private final double case;
    private final ProbabilityDistribution false = new NormalDistribution(0.0, 1.0);
    private final boolean enum;

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu, boolean isExact, boolean isCorrected) {
        super(sample1, sample2);
        int a2;
        int a3 = this.nObs();
        this.const = sample1.length;
        this.new = sample2.length;
        this.enum = isExact;
        this.char = isCorrected;
        double[] a4 = Arrays.copyOf(sample2, sample2.length);
        int a5 = 0;
        while (a5 < a4.length) {
            int n = a5++;
            a4[n] = a4[n] + mu;
        }
        double[] a22 = DoubleUtils.concat(sample1, a4);
        double[] a6 = new Rank(a22).ranks();
        int a7 = 0;
        int[] a8 = new int[this.const + this.new];
        int a9 = 1;
        double[] a10 = a22;
        Arrays.sort(a10);
        for (a2 = 1; a2 < this.const + this.new; ++a2) {
            a8[a9 - 1] = a10[a2 - 1] == a10[a2] ? a8[a9 - 1] + 1 : a8[a9 - 1];
            a9 = a10[a2 - 1] != a10[a2] ? a9 + 1 : a9;
        }
        for (a2 = 0; a2 < a9; ++a2) {
            a8[a2] = a8[a2] + 1;
            a7 = a7 + a8[a2] * a8[a2] * a8[a2] - a8[a2];
        }
        this.do = 0.0;
        for (a2 = 0; a2 < this.const; ++a2) {
            this.do += a6[a2];
        }
        this.long = new WilcoxonRankSumDistribution(this.const, this.new);
        this.case = this.const * this.new / 2;
        this.super = Math.sqrt((double)(this.const * this.new) * ((double)a3 + 1.0 - (double)a7 / (double)((this.const + this.new) * (this.const + this.new - 1))) / 12.0);
    }

    @Override
    public double statistics() {
        double a2 = this.do - (double)(this.const * (this.const + 1) / 2);
        return a2;
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu, boolean isExact) {
        this(sample1, sample2, mu, isExact, true);
    }

    public double leftOneSidedPvalue() {
        double a2 = this.statistics();
        double a3 = this.enum ? this.long.cdf(a2) : (this.char ? this.false.cdf((a2 - this.case + 0.5) / this.super) : 1.0 - this.rightOneSidedPvalue());
        return a3;
    }

    public double rightOneSidedPvalue() {
        double a2;
        double a3 = this.statistics();
        if (this.enum) {
            a2 = this.long.rightOneSidedPvalue(a3);
        } else if (this.char) {
            a2 = WilcoxonRankSum.oneSidedPvalue(this.false, (a3 - this.case - 0.5) / this.super);
        } else {
            double a4 = (a3 - this.case) / this.super;
            a2 = WilcoxonRankSum.oneSidedPvalue(this.false, a4);
        }
        return a2;
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the means are different (not by mu)";
    }

    @Override
    public double pValue() {
        double a2;
        double a3 = this.statistics();
        if (this.enum) {
            a2 = this.long.pValue(a3);
        } else if (this.char) {
            double a4 = a3 > this.case ? 0.5 : -0.5;
            double a5 = (a3 - this.case - a4) / this.super;
            double a6 = this.false.cdf(a5);
            a2 = 2.0 * Math.min(a6, 1.0 - a6);
        } else {
            a2 = 2.0 * Math.min(this.leftOneSidedPvalue(), this.rightOneSidedPvalue());
        }
        return a2;
    }

    @Override
    public String getNullHypothesis() {
        return "the means are equal (by offset mu)";
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu) {
        this(sample1, sample2, mu, sample1.length + sample2.length < 50, false);
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2) {
        this(sample1, sample2, 0.0);
    }
}

