/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.variance;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.distribution.univariate.FDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class F
extends HypothesisTest {
    private final Variance case;
    private final double false;
    private final Variance enum;

    @Override
    public double pValue() {
        double a2 = 2.0 * Math.min(this.rightOneSidedPvalue(), this.leftOneSidedPvalue());
        return a2;
    }

    public double leftOneSidedPvalue() {
        double a2 = 1.0 - this.rightOneSidedPvalue();
        return a2;
    }

    public double rightOneSidedPvalue() {
        double a2 = this.statistics();
        double a3 = F.oneSidedPvalue(this.do(), a2);
        return a3;
    }

    private ProbabilityDistribution do() {
        F a2;
        int a3 = (int)a2.enum.N() - 1;
        int a4 = (int)a2.case.N() - 1;
        FDistribution a5 = new FDistribution(a3, a4);
        return a5;
    }

    public F(double[] sample1, double[] sample2) {
        this(sample1, sample2, 1.0);
    }

    public double rightConfidenceInterval(double confidence) {
        ArgumentAssertion.assertRangeOpen(confidence, 0.0, 1.0, "confidence level");
        double a2 = this.enum.value() / this.case.value();
        return a2 / this.do().quantile(confidence);
    }

    public F(double[] sample1, double[] sample2, double ratio) {
        super(sample1, sample2);
        this.false = ratio;
        this.enum = new Variance(sample1);
        this.case = new Variance(sample2);
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the two samples have different variances";
    }

    public double[] confidenceInterval(double confidence) {
        ArgumentAssertion.assertRangeOpen(confidence, 0.0, 1.0, "confidence level");
        double a2 = this.enum.value() / this.case.value();
        double[] a3 = new double[]{a2 / this.do().quantile(confidence), a2 / this.do().quantile(1.0 - confidence)};
        return a3;
    }

    @Override
    public double statistics() {
        double a2 = this.enum.value();
        double a3 = this.case.value();
        double a4 = a2 / a3;
        double a5 = a4 / this.false;
        return a5;
    }

    public double leftConfidenceInterval(double confidence) {
        ArgumentAssertion.assertRangeOpen(confidence, 0.0, 1.0, "confidence level");
        double a2 = this.enum.value() / this.case.value();
        return a2 / this.do().quantile(1.0 - confidence);
    }

    @Override
    public String getNullHypothesis() {
        return "the two normal populations have the same variance";
    }
}

