/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.arima;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma.VARMAXModel;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.arima.ARIMAXModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VARIMAXModel {
    private final ImmutableMatrix char;
    private final ImmutableMatrix[] new;
    private final int const;
    private final ImmutableMatrix[] case;
    private final ImmutableMatrix false;
    private final ImmutableVector enum;

    public VARIMAXModel(Vector mu, Matrix[] phi, int d, Matrix[] theta, Matrix psi, Matrix sigma) {
        int a2;
        ArgumentAssertion.assertNonNegative(d, "d");
        this.const = d;
        this.enum = new ImmutableVector(mu);
        int a3 = mu.size();
        this.case = new ImmutableMatrix[phi != null ? phi.length + 1 : 1];
        this.case[0] = new ImmutableMatrix((Matrix)new DenseMatrix(a3, a3).ONE());
        if (phi != null) {
            for (a2 = 0; a2 < phi.length; ++a2) {
                ArgumentAssertion.assertTrue(phi[a2].nRows() == a3 && phi[a2].nCols() == a3, "each AR coefficient should be a square matrix of the correct dimension", new Object[0]);
                this.case[a2 + 1] = new ImmutableMatrix(phi[a2]);
            }
        }
        this.new = new ImmutableMatrix[theta != null ? theta.length + 1 : 1];
        this.new[0] = new ImmutableMatrix((Matrix)new DenseMatrix(a3, a3).ONE());
        if (theta != null) {
            for (a2 = 0; a2 < theta.length; ++a2) {
                ArgumentAssertion.assertTrue(theta[a2].nRows() == a3 && theta[a2].nCols() == a3, "each MA coefficient should be a square matrix of the correct dimension", new Object[0]);
                this.new[a2 + 1] = new ImmutableMatrix(theta[a2]);
            }
        }
        if (psi != null) {
            ArgumentAssertion.assertTrue(psi.nRows() == a3, "number of rows of psi should be the same as the dimension of the multivariate ARIMA model", new Object[0]);
            this.char = new ImmutableMatrix(psi);
        } else {
            this.char = null;
        }
        ArgumentAssertion.assertTrue(sigma.nRows() == a3 && sigma.nCols() == a3, "sigma should be a square matrix of the correct dimension", new Object[0]);
        this.false = new ImmutableMatrix(sigma);
    }

    public VARIMAXModel(Matrix[] phi, int d, Matrix[] theta, Matrix psi, Matrix sigma) {
        this(new DenseVector(DoubleUtils.rep(0.0, sigma.nRows())), phi, d, theta, psi, sigma);
    }

    public int dimension() {
        return this.enum.size();
    }

    public int d() {
        return this.const;
    }

    public VARIMAXModel(VARIMAXModel that) {
        this.enum = new ImmutableVector(new DenseVector(that.enum));
        this.case = Arrays.copyOf(that.case, that.case.length);
        this.new = Arrays.copyOf(that.new, that.new.length);
        this.char = that.char != null ? new ImmutableMatrix(new DenseMatrix(that.char)) : null;
        this.const = that.const;
        this.false = new ImmutableMatrix(new DenseMatrix(that.false));
    }

    public VARIMAXModel(Vector mu, Matrix[] phi, int d, Matrix[] theta, Matrix psi) {
        this(mu, phi, d, theta, psi, (Matrix)new DenseMatrix(mu.size(), mu.size()).ONE());
    }

    public int q() {
        return this.new.length - 1;
    }

    public ImmutableVector mu() {
        return this.enum;
    }

    public ImmutableMatrix[] theta() {
        return this.new;
    }

    public ImmutableMatrix MA(int i) {
        return i <= this.q() ? this.new[i] : new ImmutableMatrix((Matrix)this.new[0].ZERO());
    }

    public ImmutableMatrix psi() {
        return this.char != null ? this.char : null;
    }

    public VARIMAXModel(Matrix[] phi, int d, Matrix[] theta, Matrix psi) {
        this(phi, d, theta, psi, (Matrix)new DenseMatrix(phi != null ? phi[0].nRows() : theta[0].nRows(), phi != null ? phi[0].nRows() : theta[0].nRows()).ONE());
    }

    public VARIMAXModel(ARIMAXModel model) {
        int a2;
        this.enum = new ImmutableVector(new DenseVector(DoubleUtils.rep(model.mu(), 1)));
        this.const = model.d();
        this.false = new ImmutableMatrix(new DenseMatrix(new double[]{model.sigma()}, 1, 1));
        int a3 = model.p();
        int a4 = model.q();
        this.case = new ImmutableMatrix[a3 + 1];
        for (a2 = 0; a2 <= a3; ++a2) {
            this.case[a2] = new ImmutableMatrix(new DenseMatrix(new double[]{model.AR(a2)}, 1, 1));
        }
        this.new = new ImmutableMatrix[a4 + 1];
        for (a2 = 0; a2 <= a4; ++a2) {
            this.new[a2] = new ImmutableMatrix(new DenseMatrix(new double[]{model.MA(a2)}, 1, 1));
        }
        this.char = model.psi() != null ? new ImmutableMatrix(new DenseMatrix(model.psi(), 1, model.psi().length)) : null;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    static {
        Package.validate("STATS");
    }

    public VARMAXModel getVARMAX() {
        return new VARMAXModel((Vector)this.enum, (Matrix[])Arrays.copyOfRange(this.case, 1, this.case.length), (Matrix[])Arrays.copyOfRange(this.new, 1, this.new.length), (Matrix)this.char, (Matrix)this.false);
    }

    public int p() {
        return this.case.length - 1;
    }

    public ImmutableMatrix AR(int i) {
        return i <= this.p() ? this.case[i] : new ImmutableMatrix((Matrix)this.case[0].ZERO());
    }

    public ImmutableMatrix[] phi() {
        return this.case;
    }

    public ImmutableMatrix sigma() {
        return this.false;
    }
}

