/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.garch;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GARCHModel {
    private double[] case;
    private double[] false;
    private double enum;

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public double[] alpha() {
        return Arrays.copyOf(this.false, this.false.length);
    }

    public double[] beta() {
        return Arrays.copyOf(this.case, this.case.length);
    }

    public GARCHModel(double a0, double[] a2, double[] b2) {
        int a3;
        ArgumentAssertion.assertPositive(a0, "a0");
        ArgumentAssertion.assertNonNegative(DoubleArrayMath.min(a2), "{a}");
        ArgumentAssertion.assertNonNegative(DoubleArrayMath.min(b2), "{b}");
        double a4 = 0.0;
        for (a3 = 0; a3 < a2.length; ++a3) {
            a4 += a2[a3];
        }
        for (a3 = 0; a3 < b2.length; ++a3) {
            a4 += b2[a3];
        }
        ArgumentAssertion.assertLessThan(a4, 1.0, "sum of alpha and beta (except for alpha0)");
        this.enum = a0;
        this.false = Arrays.copyOf(a2, a2.length);
        this.case = Arrays.copyOf(b2, b2.length);
    }

    public double a0() {
        return this.enum;
    }

    public double sigma2(double[] e2, double[] sigma2_lag) {
        double a2 = this.enum + FunctionOps.dotProduct(this.false, e2) + FunctionOps.dotProduct(this.case, sigma2_lag);
        return a2;
    }

    static {
        Package.validate("STATS");
    }

    public int q() {
        return this.false.length;
    }

    public int p() {
        return this.case.length;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append(this.enum);
        for (a2 = 0; a2 < this.false.length; ++a2) {
            a3.append(String.format("+ %f * e_{t-%d}", this.false[a2], a2 + 1));
        }
        for (a2 = 0; a2 < this.case.length; ++a2) {
            a3.append(String.format("+ %f * h_{t-%d}", this.case[a2], a2 + 1));
        }
        return a3.toString();
    }

    public GARCHModel(GARCHModel that) {
        this.enum = that.enum;
        this.false = Arrays.copyOf(that.false, that.false.length);
        this.case = Arrays.copyOf(that.case, that.case.length);
    }

    public double var() {
        int a2;
        double a3 = 1.0;
        for (a2 = 0; a2 < this.q(); ++a2) {
            a3 -= this.false[a2];
        }
        for (a2 = 0; a2 < this.p(); ++a2) {
            a3 -= this.case[a2];
        }
        ArgumentAssertion.assertTrue((a3 = this.enum / a3) > 0.0, "invalid GARCH specification (except alpha0), sum of alpha and beta < 1; invalid variance", new Object[0]);
        return a3;
    }

    public GARCHModel(double a0, double a1, double b1) {
        this(a0, new double[]{a1}, new double[]{b1});
    }
}

