/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.Deflation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.DeflationCriterion;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.Hessenberg;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.HessenbergDeflationSearch;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.cholesky.Chol;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.algebra.linear.vector.VectorAccessException;
import com.numericalmethod.suanshu.algebra.linear.vector.VectorSizeMismatch;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;

public final class MatrixPropertyUtils {
    public static boolean isUpperBidiagonal(Matrix A2, double epsilon) {
        int a2;
        int a3;
        for (a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (a2 = A2.nCols(); a2 >= a3 + 2; --a2) {
                if (DoubleUtils.equal(0.0, A2.get(a3, a2), epsilon)) continue;
                return false;
            }
        }
        for (a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (a2 = 1; a2 <= a3 - 1 && a2 <= A2.nCols(); ++a2) {
                if (DoubleUtils.equal(0.0, A2.get(a3, a2), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isReducedRowEchelonForm(Matrix A2, double epsilon) {
        int a2 = Integer.MIN_VALUE;
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            int a4;
            for (a4 = 1; a4 <= A2.nCols(); ++a4) {
                if (DoubleUtils.equal(0.0, A2.get(a3, a4), epsilon)) continue;
                if (!DoubleUtils.equal(1.0, A2.get(a3, a4), epsilon) || a4 <= a2) {
                    return false;
                }
                for (int a5 = a3 - 1; a5 >= 1; --a5) {
                    if (DoubleUtils.equal(0.0, A2.get(a5, a4), epsilon)) continue;
                    return false;
                }
                a2 = a4;
                break;
            }
            if (a4 <= A2.nCols()) continue;
            a2 = a4;
        }
        return true;
    }

    public static boolean isPositiveDefinite(Matrix A2, double epsilon) {
        Matrix a2 = A2.t();
        Matrix a3 = A2.add(a2).scaled(0.5);
        return MatrixPropertyUtils.isSymmetricPositiveDefinite(a3, epsilon);
    }

    public static boolean areOrthogonal(Vector[] v, double epsilon) {
        for (int a2 = 0; a2 < v.length; ++a2) {
            for (int a3 = a2 + 1; a3 < v.length; ++a3) {
                if (MatrixPropertyUtils.areOrthogonal(v[a2], v[a3], epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areEqual(Matrix A1, Matrix A2, double epsilon) {
        if (!DimensionCheck.isSameDimension(A1, A2)) {
            return false;
        }
        for (int a2 = 1; a2 <= A1.nRows(); ++a2) {
            for (int a3 = 1; a3 <= A1.nCols(); ++a3) {
                if (DoubleUtils.compare(A1.get(a2, a3), A2.get(a2, a3), epsilon) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void throwIfInvalidIndex(Vector v, int index) {
        if (index < 1 || index > v.size()) {
            throw new VectorAccessException(v.size(), index);
        }
    }

    public static boolean isIdentity(Matrix A2, double epsilon) {
        boolean a2;
        boolean bl = a2 = A2.nRows() == A2.nCols();
        if (a2) {
            for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
                for (int a4 = 1; a4 <= A2.nCols(); ++a4) {
                    if (a3 == a4) {
                        a2 &= DoubleUtils.compare(A2.get(a3, a4), 1.0, epsilon) == 0;
                        continue;
                    }
                    a2 &= DoubleUtils.compare(A2.get(a3, a4), 0.0, epsilon) == 0;
                }
            }
        }
        return a2;
    }

    public static boolean isLowerBidiagonal(Matrix A2, double epsilon) {
        int a2;
        int a3;
        for (a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (a2 = 1; a2 <= a3 - 2 && a2 <= A2.nCols(); ++a2) {
                if (DoubleUtils.equal(0.0, A2.get(a3, a2), epsilon)) continue;
                return false;
            }
        }
        for (a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (a2 = A2.nCols(); a2 >= a3 + 1; --a2) {
                if (DoubleUtils.equal(0.0, A2.get(a3, a2), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areOrthogonormal(Vector v1, Vector v2, double epsilon) {
        return DoubleUtils.compare(0.0, v1.innerProduct(v2), epsilon) == 0 && DoubleUtils.compare(1.0, v1.norm(), epsilon) == 0 && DoubleUtils.compare(1.0, v2.norm(), epsilon) == 0;
    }

    public static boolean isNaN(Vector v) {
        for (int a2 = 1; a2 <= v.size(); ++a2) {
            if (!Double.isNaN(v.get(a2))) continue;
            return true;
        }
        return false;
    }

    public static boolean areEqual(Vector v1, Vector v2, double epsilon) {
        if (v1.size() != v2.size()) {
            return false;
        }
        for (int a2 = 1; a2 <= v1.size(); ++a2) {
            if (DoubleUtils.compare(v1.get(a2), v2.get(a2), epsilon) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSkewSymmetric(Matrix A2, double epsilon) {
        if (!DimensionCheck.isSquare(A2)) {
            return false;
        }
        int a2 = A2.nRows();
        for (int a3 = 1; a3 <= a2; ++a3) {
            for (int a4 = 1; a4 <= a3; ++a4) {
                if (DoubleUtils.equal(A2.get(a3, a4), -A2.get(a4, a3), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isPositiveSemiDefinite(Matrix A2, double epsilon) {
        if (!MatrixPropertyUtils.isSymmetric(A2, epsilon)) {
            return false;
        }
        Eigen a2 = new Eigen(A2, Eigen.Method.QR, epsilon);
        double[] a3 = a2.getRealEigenvalues();
        double a4 = DoubleArrayMath.min(a3);
        return !(a4 < 0.0);
    }

    public static boolean isQuasiTriangular(Matrix A2, double epsilon) {
        if (A2 instanceof UpperTriangularMatrix) {
            return true;
        }
        if (!Hessenberg.isHessenberg(A2, epsilon)) {
            return false;
        }
        HessenbergDeflationSearch a2 = new HessenbergDeflationSearch(new DeflationCriterion(){

            @Override
            public boolean isNegligible(Matrix H, int i, int j2, double epsilon) {
                return DoubleUtils.equal(0.0, H.get(i, j2), epsilon);
            }
            {
                1 a2;
            }
        }, false, epsilon);
        Deflation a3 = a2.backSearch(A2);
        return a3 == null;
    }

    public static boolean areAllSparse(Vector ... vectors) {
        for (Vector a2 : vectors) {
            if (a2 == null || a2 instanceof SparseVector) continue;
            return false;
        }
        return true;
    }

    public static boolean isSingular(Matrix A2, double epsilon) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "A must be a square matrix", new Object[0]);
        if (A2 instanceof LowerTriangularMatrix || A2 instanceof UpperTriangularMatrix) {
            boolean a2 = true;
            for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
                a2 &= !DoubleUtils.equal(A2.get(a3, a3), 0.0, epsilon);
            }
            return !a2;
        }
        return DoubleUtils.isZero(MatrixMeasure.det(A2), epsilon);
    }

    public static boolean isRowEchelonForm(Matrix A2, double epsilon) {
        int a2 = Integer.MIN_VALUE;
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            int a4;
            for (a4 = 1; a4 <= A2.nCols(); ++a4) {
                if (DoubleUtils.equal(0.0, A2.get(a3, a4), epsilon)) continue;
                if (a4 <= a2) {
                    return false;
                }
                a2 = a4;
                break;
            }
            if (a4 <= A2.nCols()) continue;
            a2 = a4;
        }
        return true;
    }

    public static boolean isIdempotent(Matrix A2, double epsilon) {
        return MatrixPropertyUtils.areEqual(A2.t(), A2.multiply(A2), epsilon);
    }

    @Deprecated
    public static boolean isScalar(Matrix A2, double epsilon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean isSymmetric(Matrix A2, double epsilon) {
        if (A2 instanceof SymmetricMatrix) {
            return true;
        }
        if (!DimensionCheck.isSquare(A2)) {
            return false;
        }
        int a2 = A2.nRows();
        for (int a3 = 1; a3 <= a2; ++a3) {
            for (int a4 = 1; a4 < a3; ++a4) {
                if (DoubleUtils.equal(A2.get(a3, a4), A2.get(a4, a3), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDiagonal(Matrix A2, double epsilon) {
        boolean a2;
        boolean bl = a2 = A2.nRows() == A2.nCols();
        if (a2) {
            for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
                for (int a4 = 1; a4 <= A2.nCols(); ++a4) {
                    if (a3 == a4) {
                        a2 &= DoubleUtils.compare(A2.get(a3, a4), 0.0, epsilon) != 0;
                        continue;
                    }
                    a2 &= DoubleUtils.compare(A2.get(a3, a4), 0.0, epsilon) == 0;
                }
            }
        }
        return a2;
    }

    @Deprecated
    public static boolean isMagicSquare(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "A must be a square matrix", new Object[0]);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void throwIfNotEqualSize(Vector v1, Vector v2) {
        if (v1.size() != v2.size()) {
            throw new VectorSizeMismatch(v1.size(), v2.size());
        }
    }

    public static boolean isZero(Vector v, double epsilon) {
        for (int a2 = 1; a2 <= v.size(); ++a2) {
            if (DoubleUtils.equal(v.get(a2), 0.0, epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllSparse(Matrix ... matrices) {
        for (Matrix a2 : matrices) {
            if (a2 == null || a2 instanceof SparseMatrix) continue;
            return false;
        }
        return true;
    }

    public static boolean areOrthogonormal(Vector[] v, double epsilon) {
        for (int a2 = 0; a2 < v.length; ++a2) {
            for (int a3 = a2 + 1; a3 < v.length; ++a3) {
                if (MatrixPropertyUtils.areOrthogonormal(v[a2], v[a3], epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    private MatrixPropertyUtils() {
        MatrixPropertyUtils a2;
    }

    public static boolean isUpperTriangular(Matrix A2, double epsilon) {
        if (A2 instanceof UpperTriangularMatrix) {
            return true;
        }
        for (int a2 = 2; a2 <= A2.nRows(); ++a2) {
            int a3 = Math.min(a2, A2.nCols());
            for (int a4 = 1; a4 < a3; ++a4) {
                if (DoubleUtils.equal(0.0, A2.get(a2, a4), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isOrthogonal(Matrix A2, double epsilon) {
        return MatrixPropertyUtils.areEqual(A2.multiply(A2.t()), A2.ONE(), epsilon);
    }

    public static boolean isSymmetricPositiveDefinite(Matrix A2, double epsilon) {
        try {
            Chol a2 = new Chol(A2, epsilon);
            LowerTriangularMatrix a3 = a2.L();
        }
        catch (RuntimeException a4) {
            return false;
        }
        return true;
    }

    public static boolean isTridiagonal(Matrix A2, double epsilon) {
        int a2;
        int a3;
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "A must be a square matrix", new Object[0]);
        for (a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (a2 = 1; a2 <= a3 - 2; ++a2) {
                if (DoubleUtils.equal(0.0, A2.get(a3, a2), epsilon)) continue;
                return false;
            }
        }
        for (a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (a2 = A2.nCols(); a2 >= a3 + 2; --a2) {
                if (DoubleUtils.equal(0.0, A2.get(a3, a2), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isLowerTriangular(Matrix A2, double epsilon) {
        if (A2 instanceof LowerTriangularMatrix) {
            return true;
        }
        for (int a2 = 1; a2 <= A2.nRows(); ++a2) {
            for (int a3 = a2 + 1; a3 <= A2.nCols(); ++a3) {
                if (DoubleUtils.equal(0.0, A2.get(a2, a3), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areOrthogonal(Vector v1, Vector v2, double epsilon) {
        return DoubleUtils.compare(0.0, v1.innerProduct(v2), epsilon) == 0;
    }
}

