/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.diagonalization;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.diagonalization.BiDiagonalization;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BiDiagonalizationByHouseholder
implements BiDiagonalization {
    private final HouseholderInPlace case;
    private final int false;
    private final int enum;

    public BiDiagonalizationByHouseholder(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isTall(A2), "Bi-diagonalization applies only to tall matrices", new Object[0]);
        this.false = A2.nRows();
        this.enum = A2.nCols();
        this.case = new HouseholderInPlace(A2);
        if (this.enum == 1) {
            this.case.generateAndReflectColumns(1, this.enum, 1, this.false);
        } else {
            int a2 = this.enum - 2;
            for (int a3 = 1; a3 <= a2; ++a3) {
                this.case.generateAndReflectColumns(a3, this.enum, a3, this.false);
                this.case.generateAndReflectRows(a3, this.false, a3 + 1, this.enum);
            }
            this.case.generateAndReflectColumns(this.enum - 1, this.enum, this.enum - 1, this.false);
            if (this.false != this.enum) {
                this.case.generateAndReflectColumns(this.enum, this.enum, this.enum, this.false);
            }
        }
    }

    @Override
    public Matrix U() {
        return this.case.U().t();
    }

    @Override
    public Matrix V() {
        return this.case.Vt().t();
    }

    @Override
    public BidiagonalMatrix B() {
        BidiagonalMatrix a2 = new BidiagonalMatrix(this.enum, BidiagonalMatrix.BidiagonalMatrixType.UPPER);
        for (int a3 = 1; a3 <= this.enum - 1; ++a3) {
            a2.set(a3, a3, this.case.get(a3, a3));
            a2.set(a3, a3 + 1, this.case.get(a3, a3 + 1));
        }
        a2.set(this.enum, this.enum, this.case.get(this.enum, this.enum));
        return a2;
    }
}

