/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.Constants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InverseIteration {
    private final ImmutableMatrix case;
    private final StoppingCriterion false;
    private final ImmutableMatrix enum;

    public InverseIteration(Matrix A2, double lambda, StoppingCriterion criterion) {
        this.enum = new ImmutableMatrix(A2);
        this.false = criterion;
        Matrix a2 = A2.minus(A2.ONE().scaled(lambda));
        this.case = new ImmutableMatrix(new Inverse(a2, 0.0));
    }

    public Vector getEigenVector() {
        return this.getEigenVector(new DenseVector(this.enum.nRows(), 1.0), 10);
    }

    public Vector getEigenVector(Vector v0, int maxIterations) {
        Vector a2 = v0;
        for (int a3 = 0; a3 < maxIterations; ++a3) {
            Vector a4 = this.case.multiply(a2);
            a2 = a4 = a4.scaled(1.0 / a4.norm());
            if (this.false.toStop(a2)) break;
        }
        return new ImmutableVector(a2);
    }

    public InverseIteration(final Matrix A2, final double lambda) {
        this(A2, lambda, new StoppingCriterion(){
            private final double false;
            private final Matrix enum;
            {
                1 a2;
                a2.enum = a2.A2.minus(a2.A2.ONE().scaled(a2.lambda));
                a2.false = Constants.unitRoundOff();
            }

            @Override
            public boolean toStop(Vector v) {
                double a2;
                Vector a3 = this.enum.multiply(v);
                double a4 = a3.norm(Double.POSITIVE_INFINITY);
                return a4 <= this.false * (a2 = MatrixMeasure.max(A2));
            }
        });
    }

    public static interface StoppingCriterion {
        public boolean toStop(Vector var1);
    }
}

