/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.mr3;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.interval.RealInterval;

public final class EigenBoundUtils {
    private EigenBoundUtils() {
        EigenBoundUtils a2;
    }

    public static RealInterval mergeIntervals(RealInterval[] intervals) {
        double a2 = intervals[0].lower();
        double a3 = intervals[0].upper();
        for (int a4 = 1; a4 < intervals.length; ++a4) {
            a2 = Math.min(a2, intervals[a4].lower());
            a3 = Math.max(a3, intervals[a4].upper());
        }
        return new RealInterval(a2, a3);
    }

    public static RealInterval[] computeGershgorinIntervals(Vector D, Vector E2) {
        int a2 = D.size();
        RealInterval[] a3 = new RealInterval[a2];
        double a4 = 0.0;
        for (int a5 = 1; a5 <= a2 - 1; ++a5) {
            RealInterval a6;
            double a7 = Math.abs(E2.get(a5));
            double a8 = a7 + a4;
            double a9 = D.get(a5);
            a3[a5 - 1] = a6 = new RealInterval(a9 - a8, a9 + a8);
            a4 = a7;
        }
        double a10 = D.get(a2);
        a3[a2 - 1] = new RealInterval(a10 - a4, a10 + a4);
        return a3;
    }
}

