/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.DeflationCriterion;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultDeflationCriterion
implements DeflationCriterion {
    private final double false;
    public static final double DEFAULT_THRESHOLD = 1.0E-12;
    private final MatrixNorm enum;

    public DefaultDeflationCriterion(double threshold, MatrixNorm matrixNorm) {
        this.false = threshold;
        this.enum = matrixNorm;
    }

    @Override
    public boolean isNegligible(Matrix H, int i, int j2, double epsilon) {
        double a2 = H.get(i, j2);
        double a3 = H.get(i - 1, j2);
        double a4 = H.get(i, j2 + 1);
        double a5 = Math.abs(a3) + Math.abs(a4);
        if (DoubleUtils.equal(a5, 0.0, epsilon)) {
            return DoubleUtils.compare(Math.abs(a2), this.false * this.enum.compute(H), epsilon) <= 0;
        }
        return DoubleUtils.compare(Math.abs(a2), this.false * a5, epsilon) <= 0;
    }

    public DefaultDeflationCriterion() {
        this(1.0E-12);
    }

    public DefaultDeflationCriterion(MatrixNorm matrixNorm) {
        this(1.0E-12, matrixNorm);
    }

    public DefaultDeflationCriterion(double threshold) {
        this(threshold, new MatrixNorm(){
            {
                1 a2;
            }

            @Override
            public double compute(Matrix A2) {
                return MatrixMeasure.Frobenius(A2);
            }
        });
    }

    public static interface MatrixNorm {
        public double compute(Matrix var1);
    }
}

