/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.DefaultDeflationCriterion;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.DeflationCriterion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.List;

public class Hessenberg {
    public final DeflationCriterion deflationCriterion;

    public Hessenberg() {
        this(new DefaultDeflationCriterion());
    }

    public static boolean isHessenberg(Matrix H, double epsilon) {
        int a2 = H.nCols();
        int a3 = H.nRows();
        for (int a4 = 1; a4 <= a2; ++a4) {
            for (int a5 = a4 + 2; a5 <= a3; ++a5) {
                if (DoubleUtils.compare(H.get(a5, a4), 0.0, epsilon) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public Hessenberg(DeflationCriterion dc) {
        this.deflationCriterion = dc;
    }

    public boolean isReducible(Matrix H, double epsilon) {
        if (!Hessenberg.isHessenberg(H, epsilon)) {
            return false;
        }
        int a2 = H.nRows();
        for (int a3 = 2; a3 <= a2; ++a3) {
            if (!this.deflationCriterion.isNegligible(H, a3, a3 - 1, epsilon)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public List<Matrix> reduce(Matrix H) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

