/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.Hessenberg;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HessenbergDecomposition {
    private volatile Matrix const = null;
    private Matrix case;
    private HouseholderInPlace false;
    private final int enum;

    public Matrix H() {
        return this.case.deepCopy();
    }

    public HessenbergDecomposition(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "Hessenberg Reduction applies only to square matrices", new Object[0]);
        this.enum = A2.nRows();
        if (Hessenberg.isHessenberg(A2, 0.0)) {
            this.case = A2.deepCopy();
            this.const = A2.ONE();
            return;
        }
        this.false = new HouseholderInPlace(A2);
        int a2 = this.enum - 2;
        for (int a3 = 1; a3 <= a2; ++a3) {
            HouseholderInPlace.Householder a4 = this.false.generateAndReflectColumns(a3, this.enum, a3 + 1, this.enum);
            this.false.rightReflect(a4, 1, this.enum);
        }
        this.case = this.false.getTransformedMatrix();
    }

    public Matrix Q() {
        if (this.const == null) {
            this.const = this.false.U().t();
        }
        return this.const.deepCopy();
    }
}

