/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.DefaultDeflationCriterion;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.Deflation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.DeflationCriterion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HessenbergDeflationSearch {
    private final double case;
    private final DeflationCriterion false;
    private final boolean enum;

    public HessenbergDeflationSearch(DeflationCriterion deflationCriterion, boolean setNegligibleEntriesToZeros, double epsilon) {
        this.false = deflationCriterion;
        this.enum = setNegligibleEntriesToZeros;
        this.case = epsilon;
    }

    public HessenbergDeflationSearch(boolean setNegligibleEntriesToZeros, double epsilon) {
        this(new DefaultDeflationCriterion(), setNegligibleEntriesToZeros, epsilon);
    }

    public Deflation backSearch(Matrix H) {
        int a2;
        int a3 = a2 = H.nRows();
        int a4 = a2;
        while (a3 >= 1) {
            if (a3 == 1 || this.false.isNegligible(H, a3, a3 - 1, this.case)) {
                if (this.enum && a4 != 2 && a3 > 1) {
                    H.set(a3, a3 - 1, 0.0);
                }
                if (a3 != a4 - 1 && a3 != a4) break;
                a4 = --a3;
                continue;
            }
            --a3;
        }
        if (a3 == 0 && a4 == 0) {
            return null;
        }
        return new Deflation(a3, a4);
    }
}

