/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.EigenvalueExtracter;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.HessenbergReduction4SymmetricMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.QRAlgorithmSkeleton;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.SchurTransformation4TridiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.GivensMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricQRAlgorithm
implements Spectrum {
    private final QRAlgorithmSkeleton.Result enum;

    public Matrix D() {
        return this.enum.T();
    }

    public Matrix Q() {
        return this.enum.Q();
    }

    public SymmetricQRAlgorithm(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2), Integer.MAX_VALUE);
    }

    public List<GivensMatrix> Gs() {
        SchurTransformation4TridiagonalMatrix.SchurDecomposition4TridiagonalMatrix a2 = (SchurTransformation4TridiagonalMatrix.SchurDecomposition4TridiagonalMatrix)this.enum.getRealSchurCanonicalFormDecomposition();
        return a2.Gs();
    }

    public List<Double> getEigenvalues() {
        List<? extends Number> a2 = this.enum.getEigenvalues();
        return a2;
    }

    public SymmetricQRAlgorithm(Matrix A2, double epsilon, int maxIterations) {
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(A2, epsilon), "symmetric QR algorithm applies only to symmetric matrix", new Object[0]);
        QRAlgorithmSkeleton a2 = new QRAlgorithmSkeleton(new HessenbergReduction4SymmetricMatrix(), new SchurTransformation4TridiagonalMatrix(epsilon, maxIterations), new EigenvalueExtracter(){
            {
                1 a2;
            }

            @Override
            public List<? extends Number> extract(Matrix D) {
                int a2 = D.nRows();
                ArrayList<Double> a3 = new ArrayList<Double>(a2);
                for (int a4 = 1; a4 <= a2; ++a4) {
                    a3.add(D.get(a4, a4));
                }
                return a3;
            }
        });
        Matrix a3 = A2 instanceof SymmetricMatrix ? A2 : new SymmetricMatrix(A2);
        this.enum = a2.process(a3);
    }

    public List<Vector> getEigenvectors() {
        Matrix a2 = this.Q();
        int a3 = a2.nCols();
        ArrayList<Vector> a4 = new ArrayList<Vector>(a3);
        for (int a5 = 1; a5 <= a3; ++a5) {
            a4.add(a2.getColumn(a5));
        }
        return a4;
    }

    public SymmetricQRAlgorithm(Matrix A2, double epsilon) {
        this(A2, epsilon, Integer.MAX_VALUE);
    }
}

