/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.DefaultDeflationCriterion;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.Deflation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.DeflationCriterion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TridiagonalDeflationSearch {
    private final double const;
    private final boolean case;
    private static final DefaultDeflationCriterion.MatrixNorm false = new DefaultDeflationCriterion.MatrixNorm(){
        {
            1 a2;
        }

        @Override
        public double compute(Matrix A2) {
            double a2 = 0.0;
            int a3 = A2.nRows();
            for (int a4 = 1; a4 <= a3; ++a4) {
                double a5 = A2.get(a4, a4);
                a2 += a5 * a5;
            }
            double a6 = 0.0;
            for (int a7 = 1; a7 <= a3 - 1; ++a7) {
                double a8 = A2.get(a7, a7 + 1);
                a6 += a8 * a8;
            }
            double a9 = Math.sqrt(a2 + (a6 *= 2.0));
            return a9;
        }
    };
    private final DeflationCriterion enum;

    public Deflation backSearch(Matrix D) {
        return this.backSearch(D, D.nRows());
    }

    private boolean break(Matrix a2, int a3, int a4) {
        TridiagonalDeflationSearch a5;
        if (a5.case) {
            return a2.get(a3, a4) == 0.0;
        }
        return a5.do(a2, a3, a4);
    }

    public TridiagonalDeflationSearch(DeflationCriterion deflationCriterion, boolean setNegligibleEntriesToZeros, double epsilon) {
        this.enum = deflationCriterion;
        this.case = setNegligibleEntriesToZeros;
        this.const = epsilon;
    }

    public Deflation backSearch(Matrix D, int startPosition) {
        int a2;
        int a3 = startPosition;
        if (this.case) {
            this.do(D, a3, this.const);
        }
        int a4 = 0;
        for (a2 = a3 - 1; a4 < a3 && a2 > 0 && this.break(D, a2 + 1, a2); ++a4, --a2) {
        }
        while (a2 > 0 && !this.break(D, a2 + 1, a2)) {
            --a2;
        }
        if (a4 >= a3 - 1) {
            return null;
        }
        return new Deflation(a2 + 1, a3 - a4);
    }

    public TridiagonalDeflationSearch(boolean setNegligibleEntriesToZeros, double epsilon) {
        this(new DefaultDeflationCriterion(false), setNegligibleEntriesToZeros, epsilon);
    }

    private boolean do(Matrix a2, int a3, int a4) {
        TridiagonalDeflationSearch a5;
        return a5.enum.isNegligible(a2, a3, a4, a5.const);
    }

    private void do(Matrix a2, int a3, double a4) {
        for (int a5 = 1; a5 <= a3 - 1; ++a5) {
            TridiagonalDeflationSearch a6;
            if (!a6.do(a2, a5 + 1, a5)) continue;
            a2.set(a5 + 1, a5, 0.0);
            a2.set(a5, a5 + 1, 0.0);
        }
    }
}

