/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.gaussianelimination;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.ElementaryOperation;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GaussianElimination {
    private PermutationMatrix long;
    private Matrix super;
    private final boolean char;
    private final double new;
    private ElementaryOperation const;
    private final int case;
    private final int false;
    private ElementaryOperation enum;

    public Matrix L() {
        return this.super.deepCopy();
    }

    public GaussianElimination(Matrix A2, boolean usePivoting, double epsilon) {
        this.case = A2.nRows();
        this.false = A2.nCols();
        this.char = usePivoting;
        this.new = epsilon;
        this.enum = new ElementaryOperation(this.case, this.case);
        this.const = new ElementaryOperation(A2);
        this.super = new DenseMatrix(this.case, this.case).ONE();
        this.long = new PermutationMatrix(this.case);
        this.do();
    }

    public Matrix T() {
        return this.enum.T();
    }

    public Matrix U() {
        return this.const.T();
    }

    public GaussianElimination(Matrix A2) {
        this(A2, true, PrecisionUtils.autoEpsilon(A2));
    }

    private void do() {
        GaussianElimination a2;
        int a3 = 1;
        for (int a4 = 1; a3 <= a2.case && a4 <= a2.false; ++a4) {
            int a5;
            int a6 = a3;
            if (a2.char) {
                for (a5 = a3 + 1; a5 <= a2.case; ++a5) {
                    if (!(Math.abs(a2.const.T().get(a5, a4)) > Math.abs(a2.const.T().get(a6, a4)))) continue;
                    a6 = a5;
                }
            }
            if (DoubleUtils.compare(a2.const.T().get(a6, a4), 0.0, a2.new) == 0) continue;
            if (a3 != a6) {
                a2.const.swapRow(a3, a6);
                a2.enum.swapRow(a3, a6);
                a2.long.swapRow(a3, a6);
                a2.do(a3, a6);
            }
            for (a5 = a3 + 1; a5 <= a2.case; ++a5) {
                double a7 = a2.const.T().get(a5, a4) / a2.const.T().get(a3, a4);
                a2.const.addRow(a5, a3, -a7);
                a2.enum.addRow(a5, a3, -a7);
                a2.super.set(a5, a4, a7);
            }
            ++a3;
        }
    }

    private void do(int a2, int a3) {
        GaussianElimination a4;
        Vector a5 = a4.super.getRow(a2);
        for (int a6 = 1; a6 < a2; ++a6) {
            a4.super.set(a2, a6, a4.super.get(a3, a6));
            a4.super.set(a3, a6, a5.get(a6));
        }
    }

    public PermutationMatrix P() {
        return new PermutationMatrix(this.long);
    }
}

