/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.svd;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.diagonalization.BiDiagonalizationByHouseholder;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.svd.GolubKahanSVDStep;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.svd.SVD2x2;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.svd.SVDDecomposition;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.GivensMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.ExceptionUtils;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GolubKahanSVD
implements SVDDecomposition {
    private final double this;
    private final int int;
    private Matrix true;
    private Matrix do;
    private DiagonalMatrix long;
    private final int super;
    private static final ParallelExecutor char = new ParallelExecutor(GolubKahanSVD.class.getSimpleName());
    private final boolean new;
    private final int const;
    private final boolean case;
    private static int false = 500;
    private Matrix enum;

    @Override
    public DiagonalMatrix D() {
        return new DiagonalMatrix(this.long);
    }

    private void break() {
        GolubKahanSVD a2;
        double[] a3 = a2.long.getDiagonal().toArray();
        a2.do(a3);
        Arrays.sort(a3);
        DoubleUtils.reverse(a3);
        a2.long = new DiagonalMatrix(a3);
    }

    private void do(Matrix a2, Matrix a3, int a4, int a5) {
        int a6 = a3.nRows();
        int a7 = 1;
        for (int a8 = a4; a8 < a5; ++a8) {
            a2.set(a8, a8, a3.get(a7, a7));
            a2.set(a8, a8 + 1, a3.get(a7, a7 + 1));
            ++a7;
        }
        a2.set(a5, a5, a3.get(a6, a6));
    }

    private Matrix byte(List<UVOperation> a2) {
        GolubKahanSVD a3;
        if (a2.size() < false) {
            return a3.do(a2);
        }
        return a3.break(a2);
    }

    private void do() {
        int a2;
        GolubKahanSVD a3;
        int a4 = a3.long.nRows();
        class UDVt {
            Vector u;
            Double sv;
            Vector vt;

            UDVt(Double a2, Vector a3, Vector a4) {
                UDVt a5;
                a5.sv = a2;
                a5.u = a3;
                a5.vt = a4;
            }
        }
        UDVt[] a5 = new UDVt[a4];
        for (int a6 = 1; a6 <= a4; ++a6) {
            double a7 = a3.long.get(a6, a6);
            a5[a6 - 1] = a3.new UDVt(a7 < 0.0 ? -a7 : a7, a7 < 0.0 ? a3.enum.getRow(a6).scaled(-1.0) : a3.enum.getRow(a6), a3.true.getColumn(a6));
        }
        class UtDVComparator
        implements Comparator<UDVt> {
            UtDVComparator() {
                UtDVComparator a2;
            }

            @Override
            public int compare(UDVt sv1, UDVt sv2) {
                return -1 * Double.compare(sv1.sv, sv2.sv);
            }
        }
        Arrays.sort(a5, a3.new UtDVComparator());
        Vector[] a8 = new Vector[a3.enum.nRows()];
        Vector[] a9 = new Vector[a3.true.nCols()];
        for (a2 = 0; a2 < a4; ++a2) {
            a8[a2] = a5[a2].u;
            a3.long.set(a2 + 1, a2 + 1, a5[a2].sv);
            a9[a2] = a5[a2].vt;
        }
        for (a2 = a4; a2 < a3.enum.nRows(); ++a2) {
            a8[a2] = new DenseVector(a3.enum.nCols());
        }
        a3.enum = MatrixFactory.rbind(a8);
        a3.true = MatrixFactory.cbind(a9);
    }

    private double[] do(double[] a2) {
        for (int a3 = 0; a3 < a2.length; ++a3) {
            if (!(a2[a3] < 0.0)) continue;
            int n = a3;
            a2[n] = a2[n] * -1.0;
        }
        return a2;
    }

    public GolubKahanSVD(Matrix A2, boolean doUV, boolean normalize, double epsilon, int maxIterations) {
        ArgumentAssertion.assertTrue(DimensionCheck.isTall(A2), "A must be tall", new Object[0]);
        this.case = doUV;
        this.new = normalize;
        this.this = epsilon;
        this.super = maxIterations;
        this.int = A2.nRows();
        this.const = A2.nCols();
        this.byte(A2);
    }

    public GolubKahanSVD(Matrix A2, boolean doUV, boolean normalize, double epsilon) {
        this(A2, doUV, normalize, epsilon, Integer.MAX_VALUE);
    }

    private Matrix do(Matrix a2, int a3, int a4) {
        int a5 = a4 - a3 + 1;
        DenseMatrix a6 = new DenseMatrix(a5, a5);
        int a7 = 1;
        for (int a8 = a3; a8 < a4; ++a8) {
            a6.set(a7, a7, a2.get(a8, a8));
            a6.set(a7, a7 + 1, a2.get(a8, a8 + 1));
            ++a7;
        }
        a6.set(a5, a5, a2.get(a4, a4));
        return a6;
    }

    private Matrix break(final List<UVOperation> a2) {
        GolubKahanSVD a3;
        int a4 = 4;
        final int a5 = (int)Math.ceil((double)a2.size() / 4.0);
        ArrayList<1> a6 = new ArrayList<1>(4);
        int a7 = 0;
        while (a7 < 4) {
            final int a8 = a7++;
            a6.add(new Callable<Matrix>(){

                @Override
                public Matrix call() throws Exception {
                    int a22 = a8 * a5;
                    int a3 = Math.min(a22 + a5, a2.size());
                    return GolubKahanSVD.this.do(a2.subList(a22, a3));
                }
                {
                    1 a22;
                }
            });
        }
        try {
            List a9 = char.executeAll(a6);
            Matrix a10 = (Matrix)a9.get(0);
            for (int a11 = 1; a11 < a9.size(); ++a11) {
                a10 = a10.multiply((Matrix)a9.get(a11));
            }
            return a10;
        }
        catch (MultipleExecutionException a12) {
            return a3.do(a2);
        }
    }

    private List<GivensMatrix> final(Matrix a2) {
        int a3;
        int a4 = a2.nCols();
        for (a3 = 1; a3 < a4; ++a3) {
            GolubKahanSVD a5;
            if (!DoubleUtils.isZero(a2.get(a3, a3), a5.this) || DoubleUtils.isZero(a2.get(a3, a3 + 1), a5.this)) continue;
            a2.set(a3, a3, 0.0);
            break;
        }
        if (a3 >= a4) {
            throw new RuntimeException("no zero diagonal entry");
        }
        ArrayList<GivensMatrix> a6 = new ArrayList<GivensMatrix>(a4 - a3);
        for (int a7 = a3 + 1; a7 <= a4; ++a7) {
            GivensMatrix a8 = GivensMatrix.CtorToRotateRows(a4, a7, a3, a2.get(a7, a7), a2.get(a3, a7));
            a8.multiplyInPlace(a2);
            a6.add((GivensMatrix)a8.t());
        }
        return a6;
    }

    @Override
    public double[] getSingularValues() {
        double[] a2 = this.long.getDiagonal().toArray();
        return this.new ? a2 : this.do(a2);
    }

    private void byte(Matrix a2) {
        Object a3;
        Matrix a4;
        GolubKahanSVD a5;
        BiDiagonalizationByHouseholder a6 = new BiDiagonalizationByHouseholder(a2);
        Matrix a7 = a6.U();
        Matrix a8 = a6.V();
        DenseMatrix a9 = a6.B().toDense();
        ArrayList<UVOperation> a10 = new ArrayList<UVOperation>(2 * a5.const);
        ArrayList<UVOperation> a11 = new ArrayList<UVOperation>(2 * a5.const);
        int a12 = 0;
        int a13 = 0;
        int a14 = 0;
        for (a14 = 0; a14 < a5.super; ++a14) {
            a5.do(a9);
            for (a12 = a5.const; a12 > 1 && a5.do((Matrix)a9, a12 - 1, a5.this); --a12) {
            }
            if (a12 <= 1) break;
            for (a13 = a12 - 1; a13 >= 2 && !a5.do((Matrix)a9, a13 - 1, a5.this); --a13) {
            }
            int a15 = a12 - a13 + 1;
            a4 = a5.do((Matrix)a9, a13, a12);
            if (DoubleUtils.isZero(a4.get(a15, a15), a5.this)) {
                a3 = a5.break(a4);
                if (a5.case) {
                    a11.add(a5.new MultiplyGivensMatrices((List)a3, a13));
                }
            } else if (DoubleUtils.hasZero(VectorFactory.diagonal(a4).toArray(), a5.this)) {
                a3 = a5.final(a4);
                if (a5.case) {
                    a10.add(a5.new MultiplyGivensMatrices((List)a3, a13));
                }
            } else if (a15 == 2) {
                a3 = new SVD2x2(a4);
                a4 = ((SVD2x2)a3).D();
                if (a5.case) {
                    a10.add(a5.new Multiply2x2Block(((SVD2x2)a3).U(), a13));
                    a11.add(a5.new Multiply2x2Block(((SVD2x2)a3).V(), a13));
                }
            } else {
                a3 = new BidiagonalMatrix(new double[][]{VectorFactory.superDiagonal(a4).toArray(), VectorFactory.diagonal(a4).toArray()});
                GolubKahanSVDStep a16 = new GolubKahanSVDStep((BidiagonalMatrix)a3);
                a4 = a16.UtBV().toDense();
                if (a5.case) {
                    a10.add(a5.new MultiplyGivensMatrices(a16.getGivensMatricesForU(), a13));
                    a11.add(a5.new MultiplyGivensMatrices(a16.getGivensMatricesForV(), a13));
                }
            }
            a5.do(a9, a4, a13, a12);
        }
        if (a14 == a5.super) {
            throw new RuntimeException(String.format("diagonalization cannot converge in %d iterations", a5.super));
        }
        a5.long = new DiagonalMatrix(VectorFactory.diagonal(a9).toArray());
        if (a5.case) {
            Matrix a17;
            a4 = a17 = a5.byte(a10);
            if (a5.int > a5.const) {
                a4 = MatrixFactory.rbind(a17, new DenseMatrix(a5.int - a5.const, a5.const));
            }
            a5.do = a7.multiply(a4);
            a5.enum = a5.do.t();
            a3 = a5.byte(a11);
            a5.true = a8.multiply((Matrix)a3);
        }
        if (a5.new) {
            if (a5.case) {
                a5.do();
            } else {
                a5.break();
            }
        }
    }

    @Override
    public Matrix Ut() {
        ExceptionUtils.throwIfNotNull(this.case ? null : new RuntimeException("only singular values were computed; U not available"));
        return this.enum.deepCopy();
    }

    private boolean break(Matrix a2, int a3, double a4) {
        GolubKahanSVD a5;
        boolean a6 = a5.do(a2, a3, a4);
        if (a6) {
            a2.set(a3, a3 + 1, 0.0);
        }
        return a6;
    }

    private Matrix do(List<UVOperation> a2) {
        GolubKahanSVD a3;
        Matrix a4 = MatrixFactory.identity(a3.const, a3.const);
        for (UVOperation a5 : a2) {
            a5.doOperation(a4);
        }
        return a4;
    }

    @Override
    public Matrix U() {
        ExceptionUtils.throwIfNotNull(this.case ? null : new RuntimeException("only singular values were computed; U not available"));
        return this.enum.t();
    }

    private List<GivensMatrix> break(Matrix a2) {
        int a3;
        int a4 = a2.nRows();
        ArrayList<GivensMatrix> a5 = new ArrayList<GivensMatrix>(a4 - 1);
        for (a3 = a4 - 1; a3 >= 1; --a3) {
            GivensMatrix a6 = GivensMatrix.CtorToRotateColumns(a4, a3, a4, a2.get(a3, a3), a2.get(a3, a4));
            a6.rightMultiplyInPlace(a2);
            a5.add(a6);
        }
        for (a3 = a4; a3 >= 1; --a3) {
            a2.set(a3, a4, 0.0);
        }
        return a5;
    }

    private void do(Matrix a2, List<GivensMatrix> a3, int a4) {
        for (GivensMatrix a5 : a3) {
            GolubKahanSVD a6;
            int a7 = a5.i() + a4 - 1;
            int a8 = a5.j() + a4 - 1;
            GivensMatrix a9 = new GivensMatrix(a6.const, a7, a8, a5.c(), a5.s());
            a9.rightMultiplyInPlace(a2);
        }
    }

    private void do(Matrix a2) {
        int a3 = Math.min(a2.nRows(), a2.nCols());
        for (int a4 = 1; a4 <= a3 - 1; ++a4) {
            GolubKahanSVD a5;
            a5.break(a2, a4, a5.this);
        }
    }

    private void do(Matrix a2, Matrix a3, int a4) {
        GolubKahanSVD a5;
        double a6 = a3.get(1, 1);
        double a7 = a3.get(1, 2);
        double a8 = a3.get(2, 1);
        double a9 = a3.get(2, 2);
        int a10 = a4;
        int a11 = a10 + 1;
        for (int a12 = 1; a12 <= a5.const; ++a12) {
            double a13 = a2.get(a12, a10);
            double a14 = a2.get(a12, a11);
            a2.set(a12, a10, a13 * a6 + a14 * a8);
            a2.set(a12, a11, a13 * a7 + a14 * a9);
        }
    }

    @Override
    public Matrix V() {
        ExceptionUtils.throwIfNotNull(this.case ? null : new RuntimeException("only singular values were computed; V not available"));
        return this.true.deepCopy();
    }

    private boolean do(Matrix a2, int a3, double a4) {
        double a5 = Math.abs(a2.get(a3, a3 + 1));
        return DoubleUtils.compare(a5, 0.0, a4) == 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class MultiplyGivensMatrices
    implements UVOperation {
        private final List<GivensMatrix> false;
        private final int enum;

        private MultiplyGivensMatrices(List<GivensMatrix> a2, int a3) {
            MultiplyGivensMatrices a4;
            a4.false = a2;
            a4.enum = a3;
        }

        @Override
        public void doOperation(Matrix UorV) {
            GolubKahanSVD.this.do(UorV, this.false, this.enum);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class Multiply2x2Block
    implements UVOperation {
        private final Matrix false;
        private final int enum;

        private Multiply2x2Block(Matrix a2, int a3) {
            Multiply2x2Block a4;
            a4.false = a2;
            a4.enum = a3;
        }

        @Override
        public void doOperation(Matrix UorV) {
            GolubKahanSVD.this.do(UorV, this.false, this.enum);
        }
    }

    private static interface UVOperation {
        public void doOperation(Matrix var1);
    }
}

